*** Settings ***
Resource    environment/variables.txt 
Resource   NSLCMOperationKeywords.robot   
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    Process
Suite Setup       Initialize System
Suite Teardown    Terminate All Processes    kill=true

*** Test Cases ***
Instantiate Flow of NS lifecycle management operations
    [Documentation]    Test ID: 5.3.2.21.1
    ...    Test title: Instantiate Flow of NS lifecycle management operations
    ...    Test objective: The objective is to test the workflow for Instantiate a NS instance
    ...    Pre-conditions: The resource is in NOT_INSTANTIATED state
    ...    Reference: Clause 6.4.4 - ETSI GS NFV-SOL 005 [3] v2.8.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: The resource is in INSTANTIATED state
    POST Instantiate nsInstance
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location
    Check Individual NS LCM operation occurrence operationState is    PROCESSING
    Check Operation Notification Status is    START
    Check Operation Notification Status is    RESULT
    Check resource instantiated
    
    
    
    
    
    
    
    
    