*** Settings ***
Resource    environment/variables.txt 
Resource    VnfLcmOperationKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}        ssl_verify=false
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
*** Test Cases ***
Post Individual VNF LCM OP occurrence - Method not implemented
    [Documentation]    Test ID: 6.3.5.12.1
    ...    Test title: Post Individual VNF LCM OP occurrence - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.1 - ETSI GS NFV-SOL 002 [2] v2.8.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Individual VNF LCM OP occurrence
    Check HTTP Response Status Code Is    405
    
Get Individual VNF LCM OP occurrence
    [Documentation]    Test ID: 6.3.5.12.2
    ...    Test title: Get Individual VNF LCM OP occurrence
    ...    Test objective: The objective is to test that this method retrieve a VNF lifecycle management operation occurrence and perform a JSON schema validation of the returned data structure
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.2 - ETSI GS NFV-SOL 002 [2] v2.8.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get Individual VNF LCM OP occurrence
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfLcmOpOcc
    Check HTTP Response Body vnf LCM OpOCC content against VNF Descriptor

PUT Individual VNF LCM OP occurrence - Method not implemented
    [Documentation]    Test ID: 6.3.5.12.3
    ...    Test title: PUT Individual VNF LCM OP occurrence - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.3 - ETSI GS NFV-SOL 002 [2] v2.8.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none  
    Put Individual VNF LCM OP occurrence
    Check HTTP Response Status Code Is    405

PATCH Individual VNF LCM OP occurrence - Method not implemented
    [Documentation]    Test ID: 6.3.5.12.4
    ...    Test title: PATCH Individual VNF LCM OP occurrence - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.4 - ETSI GS NFV-SOL 002 [2] v2.8.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none      
    Patch Individual VNF LCM OP occurrence
    Check HTTP Response Status Code Is    405
    
DELETE Individual VNF LCM OP occurrence - Method not implemented
    [Documentation]    Test ID: 6.3.5.12.5
    ...    Test title: DELETE Individual VNF LCM OP occurrence - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.5 - ETSI GS NFV-SOL 002 [2] v2.8.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none  
    Delete Individual VNF LCM OP occurrence
    Check HTTP Response Status Code Is    405

