/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.model.HttpRequest;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.serialization.model.VerificationTimesDTO;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationTimes;

public class VerificationDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<Verification> {
    private HttpRequestDTO httpRequest;
    private VerificationTimesDTO times;

    public VerificationDTO(Verification verification) {
        if (verification != null) {
            this.httpRequest = new HttpRequestDTO(verification.getHttpRequest());
            this.times = new VerificationTimesDTO(verification.getTimes());
        }
    }

    public VerificationDTO() {
    }

    @Override
    public Verification buildObject() {
        return Verification.verification().withRequest(this.httpRequest != null ? this.httpRequest.buildObject() : HttpRequest.request()).withTimes(this.times != null ? this.times.buildObject() : VerificationTimes.once());
    }

    public HttpRequestDTO getHttpRequest() {
        return this.httpRequest;
    }

    public VerificationDTO setHttpRequest(HttpRequestDTO httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public VerificationTimesDTO getTimes() {
        return this.times;
    }

    public VerificationDTO setTimes(VerificationTimesDTO times) {
        this.times = times;
        return this;
    }
}

