/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.socks;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.socksx.v4.DefaultSocks4CommandResponse;
import io.netty.handler.codec.socksx.v4.Socks4CommandRequest;
import io.netty.handler.codec.socksx.v4.Socks4CommandStatus;
import io.netty.handler.codec.socksx.v4.Socks4CommandType;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.proxy.socks.Socks4ConnectHandler;
import org.mockserver.proxy.socks.SocksProxyHandler;

@ChannelHandler.Sharable
public class Socks4ProxyHandler
extends SocksProxyHandler<Socks4CommandRequest> {
    public Socks4ProxyHandler(LifeCycle server, MockServerLogger mockServerLogger) {
        super(server, mockServerLogger);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Socks4CommandRequest commandRequest) {
        if (commandRequest.type().equals(Socks4CommandType.CONNECT)) {
            this.forwardConnection(ctx, new Socks4ConnectHandler(this.server, this.mockServerLogger, commandRequest.dstAddr(), commandRequest.dstPort()), commandRequest.dstAddr(), commandRequest.dstPort());
            ctx.fireChannelRead(commandRequest);
        } else {
            ctx.writeAndFlush(new DefaultSocks4CommandResponse(Socks4CommandStatus.REJECTED_OR_FAILED)).addListener(ChannelFutureListener.CLOSE);
        }
    }
}

