/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.apache.commons.lang3.StringUtils;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;

public class SubStringMatcher
extends BodyMatcher<NottableString> {
    private static final String[] excludedFields = new String[]{"mockserverLogger"};
    private final MockServerLogger mockServerLogger;
    private final NottableString matcher;

    public SubStringMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = NottableString.string(matcher);
    }

    public SubStringMatcher(MockServerLogger mockServerLogger, NottableString matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
    }

    public static boolean matches(String matcher, String matched, boolean ignoreCase) {
        boolean result = false;
        if (StringUtils.isEmpty(matcher)) {
            result = true;
        } else if (matched != null) {
            if (StringUtils.contains((CharSequence)matched, matcher)) {
                result = true;
            }
            if (ignoreCase && StringUtils.containsIgnoreCase(matched, matcher)) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean matches(HttpRequest context, String matched) {
        return this.matches(context, NottableString.string(matched));
    }

    @Override
    public boolean matches(HttpRequest context, NottableString matched) {
        boolean result = false;
        if (SubStringMatcher.matches(this.matcher.getValue(), matched.getValue(), false)) {
            result = true;
        }
        if (!result) {
            this.mockServerLogger.trace(context, "Failed to match [{}] with [{}]", matched, this.matcher);
        }
        return matched.isNot() != (this.matcher.isNot() != (this.not != result));
    }

    @Override
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

