/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.mockserver.collections.CaseInsensitiveRegexHashMap;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.KeysAndValues;

public class HashMapMatcher
extends NotMatcher<KeysAndValues> {
    private final MockServerLogger mockServerLogger;
    private final CaseInsensitiveRegexHashMap hashMap;

    public HashMapMatcher(MockServerLogger mockServerLogger, KeysAndValues keysAndValues) {
        this.mockServerLogger = mockServerLogger;
        this.hashMap = keysAndValues != null ? keysAndValues.toCaseInsensitiveRegexMultiMap() : null;
    }

    @Override
    public boolean matches(HttpRequest context, KeysAndValues values) {
        boolean result = false;
        if (this.hashMap == null || this.hashMap.isEmpty() || values == null) {
            result = true;
        } else if (values.toCaseInsensitiveRegexMultiMap().containsAll(this.hashMap)) {
            result = true;
        } else {
            this.mockServerLogger.trace(context, "Map [{}] is not a subset of {}", this.hashMap, values);
        }
        return this.not != result;
    }
}

