/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty.websocket;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLException;
import org.mockserver.client.netty.websocket.WebSocketClientHandler;
import org.mockserver.client.netty.websocket.WebSocketException;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.mock.action.ExpectationResponseCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.serialization.WebSocketMessageSerializer;
import org.mockserver.serialization.model.WebSocketClientIdDTO;

public class WebSocketClient {
    private Channel channel;
    private EventLoopGroup group = new NioEventLoopGroup();
    private WebSocketMessageSerializer webSocketMessageSerializer = new WebSocketMessageSerializer(new MockServerLogger());
    private SettableFuture<String> registrationFuture = SettableFuture.create();
    private ExpectationResponseCallback expectationResponseCallback;
    private ExpectationForwardCallback expectationForwardCallback;

    public WebSocketClient(final InetSocketAddress serverAddress, String contextPath, final boolean isSecure) {
        try {
            final WebSocketClientHandler webSocketClientHandler = new WebSocketClientHandler(serverAddress, contextPath, this);
            this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) {
                    if (isSecure) {
                        try {
                            ch.pipeline().addLast(SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE).build().newHandler(ch.alloc(), serverAddress.getHostName(), serverAddress.getPort()));
                        }
                        catch (SSLException e) {
                            throw new WebSocketException("Exception when configuring SSL Handler", e);
                        }
                    }
                    ch.pipeline().addLast(new HttpClientCodec(), new HttpObjectAggregator(Integer.MAX_VALUE), webSocketClientHandler);
                }
            })).connect(serverAddress).sync().channel();
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while starting web socket client", e);
        }
    }

    SettableFuture<String> registrationFuture() {
        return this.registrationFuture;
    }

    void receivedTextWebSocketFrame(TextWebSocketFrame textWebSocketFrame) {
        try {
            Object deserializedMessage = this.webSocketMessageSerializer.deserialize(textWebSocketFrame.text());
            if (deserializedMessage instanceof HttpRequest) {
                HttpRequest httpRequest = (HttpRequest)deserializedMessage;
                String webSocketCorrelationId = httpRequest.getFirstHeader("WebSocketCorrelationId");
                if (this.expectationResponseCallback != null) {
                    HttpResponse httpResponse = this.expectationResponseCallback.handle(httpRequest);
                    httpResponse.withHeader("WebSocketCorrelationId", webSocketCorrelationId);
                    this.channel.writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(httpResponse)));
                }
                if (this.expectationForwardCallback != null) {
                    HttpRequest forwardedHttpRequest = this.expectationForwardCallback.handle(httpRequest);
                    forwardedHttpRequest.withHeader("WebSocketCorrelationId", webSocketCorrelationId);
                    this.channel.writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(forwardedHttpRequest)));
                }
            } else if (!(deserializedMessage instanceof WebSocketClientIdDTO)) {
                throw new WebSocketException("Unsupported web socket message " + deserializedMessage);
            }
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while receiving web socket message", e);
        }
    }

    public void stopClient() {
        if (!this.group.isShuttingDown() || this.group.isShutdown()) {
            this.group.shutdownGracefully();
        }
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close().sync();
                this.channel = null;
            }
        }
        catch (InterruptedException e) {
            throw new WebSocketException("Exception while closing client", e);
        }
    }

    public WebSocketClient registerExpectationCallback(ExpectationResponseCallback expectationResponseCallback) {
        if (this.expectationForwardCallback != null) {
            throw new IllegalArgumentException("It is not possible to set response callback once a forward callback has been set");
        }
        this.expectationResponseCallback = expectationResponseCallback;
        return this;
    }

    public WebSocketClient registerExpectationCallback(ExpectationForwardCallback expectationForwardCallback) {
        if (this.expectationResponseCallback != null) {
            throw new IllegalArgumentException("It is not possible to set forward callback once a response callback has been set");
        }
        this.expectationForwardCallback = expectationForwardCallback;
        return this;
    }

    public String clientId() {
        try {
            return (String)this.registrationFuture.get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof WebSocketException && e.getCause().getMessage().contains("ExpectationResponseCallback and ExpectationForwardCallback is not supported")) {
                throw new WebSocketException(e.getCause().getMessage());
            }
            throw new WebSocketException("Unable to retrieve client registration id", e);
        }
    }
}

