*** Settings ***
Library    JSONSchemaLibrary    schemas/
Resource    environment/variables.txt
Library    JSONLibrary
Library    OperatingSystem
Library    String
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
NS Performance Information Availability Notification
    [Documentation]    Test ID: 5.3.4.10.1
    ...    Test title: NS Performance Information Availability Notification
    ...    Test objective: The objective is to test that NS Performance Information Availability Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A NS performance job is created, and information availability notifications is available in the NFVO.
    ...    Reference: Clause 7.4.9.3.1 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post NS Performance Information Availability Notification
    Check HTTP Response Status Code Is    204
    
NS Threshold Crossed Notification
    [Documentation]    Test ID: 5.3.4.10.2
    ...    Test title: NS Threshold Crossed Notification
    ...    Test objective: The objective is to test that NS Threshold Crossed Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A NS performance job is created, and threshold crossed notifications is available in the NFVO.
    ...    Reference: Clause 7.4.9.3.1 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post NS Threshold Crossed Notification
    Check HTTP Response Status Code Is    204
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    Integer    response status    200
    Validate Json    response body    PmJob.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 
    
Post NS Performance Information Availability Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body} =    Get File    jsons/PerformanceInformationAvailableNotification.json  
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
Post NS Threshold Crossed Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body} =    Get File    jsons/ThresholdCrossedNotification.json  
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}