*** Settings ***
Resource   environment/variables.txt 
Resource   NSInstanceUsageNotificationKeywords.robot 
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/

*** Test Cases ***
POST Create a new subscription
    [Documentation]    Test ID: 9.3.4.1.1
    ...    Test title: POST Create a new subscription
    ...    Test objective: The objective is to test that POST method creates a subscription
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: Subscription is created in the NFVO     
    POST subscriptions
    Check HTTP Response Status Code Is    201
    Check HTTP Response Header Contains    Location
    Check HTTP Response Body Json Schema Is    subscription
    Check HTTP Response Header Contains Resource URI

POST Create a new Subscription - DUPLICATION
    [Documentation]    Test ID: 9.3.4.1.2
    ...    Test title: POST Create a new subscription - DUPLICATION
    ...    Test objective: The objective is to test that POST method creates a duplicate subscription 
    ...    Pre-conditions: A subscription shall already exist 
    ...    Reference: Clause 8.5.3.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: Duplication supported by NFVO-C
    ...    Post-Conditions: Duplicate subscription is created in the NFVO     
    POST subscriptions DUPLICATION
    Check Subscription Existence
    Check HTTP Response Status Code Is    201
    Check HTTP Response Header Contains    Location
    Check HTTP Response Body Json Schema Is    subscription 
    
POST Create a new Subscription - NO-DUPLICATION
    [Documentation]    Test ID: 9.3.4.1.3
    ...    Test title: POST Create a new subscription - NO-DUPLICATION
    ...    Test objective: The objective is to test that POST method cannot create a duplicate subscription 
    ...    Pre-conditions: A subscription shall already exist
    ...    Reference: Clause 8.5.3.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: Duplication NOT supported by NFVO-C
    ...    Post-Conditions: Duplicate subscription is not created in the NFVO     
    POST subscriptions NO DUPLICATION
    Check Subscription Existence
    Check HTTP Response Status Code Is    303
    Check HTTP Response Header Contains    Location
    
GET Subscriptions
    [Documentation]    Test ID: 9.3.4.1.4
    ...    Test title: GET Subscriptions
    ...    Test objective: The objective is to test that GET method retrieves the list of existing subscriptions
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none    
    GET Subscriptions
    Check HTTP Response Status Code Is  200
    Check HTTP Response Body Json Schema Is  subscriptions

GET Subscription - Filter
    [Documentation]    Test ID: 9.3.4.1.5
    ...    Test title: GET Subscription - Filter
    ...    Test objective: The objective is GET the list of active subscriptions using a filter
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none    
    GET Subscriptions with filter
    Check HTTP Response Status Code Is  200
    Check HTTP Response Body Json Schema Is  subscriptions
    
GET subscriptions - Bad Request Invalid attribute-based filtering parameters
    [Documentation]    Test ID: 9.3.4.1.6
    ...    Test title: GET subscriptions - Bad Request Invalid attribute-based filtering parameters
    ...    Test objective: The objective is GET the list of active subscriptions using an invalid filter
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get subscriptions - invalid filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET subscriptions - Bad Request Response too Big
    [Documentation]    Test ID: 9.3.4.1.7
    ...    Test title: GET subscriptions - Bad Request Response too Big
    ...    Test objective: The objective is test that the retrieval of active subscriptions list fails because response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    GET Subscriptions
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET subscriptions with "all_fields" attribute selector
    [Documentation]    Test ID: 9.3.4.1.8
    ...    Test title: GET subscriptions with "all_fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "all_fields" attribute selector
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none 
    ...    Post-Conditions: none
    Get subscriptions with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions 

GET subscriptions with "exclude_default" attribute selector
    [Documentation]    Test ID: 9.3.4.1.9
    ...    Test title: GET subscriptions with "exclude_default" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "exclude_default"s attribute selector
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get subscriptions with exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions

GET subscriptions with "fields" attribute selector
    [Documentation]    Test ID: 9.3.4.1.10
    ...    Test title: GET subscriptions with "fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "fields" attribute selector
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get subscriptions with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions

GET subscriptions with "exclude_fields" attribute selector
    [Documentation]    Test ID: 9.3.4.1.11
    ...    Test title: GET subscriptions with "exclude_fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "exclude_fields" attribute selector
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability:  none
    ...    Post-Conditions: none
    Get subscriptions with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions  
        
GET Subscriptions as Paged Response
    [Documentation]    Test ID: 9.3.4.1.12
    ...    Test title: GET Subscriptions as Paged Response
    ...    Test objective: The objective is to test that GET method  retrieve the list of existing subscriptions as paged response.
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none    
    GET Subscriptions
    Check HTTP Response Status Code Is  200
    Check HTTP Response Header Contains Link
        
PUT subscriptions - Method not implemented
     [Documentation]    Test ID: 9.3.4.1.13
    ...    Test title: PUT subscriptions - Method not implemented
    ...    Test objective: The objective is to test that PUT method cannot modify a NS instance usage subscription
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.3 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT subscriptions
    Check HTTP Response Status Code Is    405

PATCH subscriptions - Method not implemented
    [Documentation]    Test ID: 9.3.4.1.14
    ...    Test title: PATCH subscriptions - Method not implemented
    ...    Test objective: The objective is to test that PUT method cannot modify a NS instance usage subscription
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.4 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH subscriptions
    Check HTTP Response Status Code Is    405

DELETE subscriptions - Method not implemented
    [Documentation]    Test ID: 9.3.4.1.15
    ...    Test title: DELETE subscriptions - Method not implemented
    ...    Test objective: The objective is to test that DELETE method cannot delete a NS instance usage subscription
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.3.3.5 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: Subscriptions are not deleted
    DELETE subscriptions
    Check HTTP Response Status Code Is    405
    
GET subscriptions with "exclude_default" and "fields" attribute selector
    [Documentation]    Test ID: 9.3.4.1.16
    ...    Test title: GET subscriptions with "exclude_default" and "fields" attribute selector
    ...    Test objective: The objective is to retrieve the list of active subscriptions with "exclude_default" and "fields" attribute selector
    ...    Pre-conditions: 
    ...    Reference: Clause 8.5.3.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability:  
    ...    Post-Conditions: 
    Get subscriptions with exclude_default and fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscriptions  