*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           OperatingSystem
Library           JSONLibrary
Library           String
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
Alarm Notification
    [Documentation]    Test ID: 8.3.3.7.1
    ...    Test title: Alarm Notification
    ...    Test objective: The objective is to test that Alarm Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A subscription for alarm notification is available in the NFV-MANO.
    ...    Reference: clause 7.5.7.3.1 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Alarm Notification
    Check HTTP Response Status Code Is    204

Alarm Cleared Notification
    [Documentation]    Test ID: 8.3.3.7.2
    ...    Test title: Alarm Cleared Notification
    ...    Test objective: The objective is to test that Alarm Cleared Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A subscription for alarm cleared notification is available in the NFV-MANO.
    ...    Reference: clause 7.5.7.3.1 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Alarm Cleared Notification
    Check HTTP Response Status Code Is    204

Alarm List Rebuilt Notification
    [Documentation]    Test ID: 8.3.3.7.3
    ...    Test title: Alarm List Rebuilt Notification
    ...    Test objective: The objective is to test that Alarm List Rebuilt Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A subscription for alarm list rebuilt notification is available in the NFV-MANO.
    ...    Reference: clause 7.5.7.3.1 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Alarm List Rebuilt Notification
    Check HTTP Response Status Code Is    204
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    Integer    response status    200
    Validate Json    response body    FmSubscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 

Post Alarm Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/AlarmNotification.json  
    ${body}=    Format String    ${template}    subscriptionId=${subscriptionId}    alarmId=${alarmId}    managedObjectId=${managedObjectId}
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Post Alarm Cleared Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/AlarmClearedNotification.json  
    ${body}=    Format String    ${template}    subscriptionId=${subscriptionId}    alarmId=${alarmId}
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
    
Post Alarm List Rebuilt Notification
    log    Trying to perform a POST to get notifications
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/AlarmListRebuiltNotification.json  
    ${body}=    Format String    ${template}    subscriptionId=${subscriptionId}
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

