*** Settings ***
Resource   environment/variables.txt 
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    Collections
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Variables    descriptors/SOL001/VNFD/vnfd_SOL001.yaml
Variables    descriptors/SOL006/VNFD/vnfd_SOL006.yaml
Documentation    This resource represents an individual grant. The client can use this resource to read the grant.
...    It is determined by means outside the scope of the present document, such as configuration or policy,
...    how long an individual grant is available.

*** Test Cases ***
POST Individual Grant - Method not implemented
    [Documentation]    Test ID: 7.3.2.2.1
    ...    Test title: POST Individual Grant - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed for Life cycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.4 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post individual Grant
    Check HTTP Response Status Code Is    405

GET an individual grant - Successful
    [Documentation]    Test ID: 7.3.2.2.2
    ...    Test title: GET an individual grant - Successful
    ...    Test objective: The objective is to retrieve a grant for a particular VNF Lifecycle Operation.
    ...    Pre-conditions: The  grant information is available to the VNFM
    ...    Reference: Clause 9.4.3.3.2 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get individual grant
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    grant
    Check HTTP Response Body grant content against VNF Descriptor
    
GET an individual grant - Process ongoing
    [Tags]    no-synchronous-mode
    [Documentation]    Test ID: 7.3.2.2.3
    ...    Test title: GET an individual grant - Process ongoing
    ...    Test objective: The objective is to retrieve a grant for a particular VNF lifecycle operation when process is ongoing and no grant is available yet.
    ...    Pre-conditions: The process of creating the grant is ongoing, no grant is available yet.
    ...    Reference: Clause 9.4.3.3.2 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get individual grant
    Check HTTP Response Status Code Is    202
    Check HTTP Response Body Json Schema Is    grant
    
GET an individual grant - grant rejected
    [Tags]    no-synchronous-mode
    [Documentation]    Test ID: 7.3.2.2.4
    ...    Test title: GET an individual grant - grant rejected
    ...    Test objective: The objective is to retrieve a grant for a particular VNF Lifecycle Operation but error returned because grant has been rejected.
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.3.3.2 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get individual grant
    Check HTTP Response Status Code Is    403
	Check HTTP Response Body Json Schema Is    ProblemDetails

PUT an individual grant - Method not implemented
    [Documentation]    Test ID: 7.3.2.2.5
    ...    Test title: PUT an individual grant - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to for Life cycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.3.3.3 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT individual Grant
    Check HTTP Response Status Code Is    405

PATCH an individual grant - Method not implemented
    [Documentation]    Test ID: 7.3.2.2.6
    ...    Test title: PATCH an individual grant - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to for Life cycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.3.3.4 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Patch individual Grant
    Check HTTP Response Status Code Is    405
    
DELETE an individual grant - Method not implemented
    [Documentation]    Test ID: 7.3.2.2.7
    ...    Test title: DELETE an individual grant - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to for Life cycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.3.3.5 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Delete individual Grant
    Check HTTP Response Status Code Is    405

*** Keywords ***    
Get individual grant
    log    Trying to read an individual grant
    Set Headers    {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId} 
    Integer    response status    200
    
Post individual Grant
    log    Trying to read an individual grant
    Pass Execution If    ${SYNC_MODE} == 1   Skipping. Synchronous mode is supported    
    Set Headers    {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Put individual Grant
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Patch individual Grant
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Delete individual Grant
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    
Check HTTP Response Body grant content against VNF Descriptor
    Run Keyword If    ${check_descriptors} == 1    Check Individual grant Content
    
Check Individual grant Content    
    PARSE the Descriptor File
    Match the grant Response Attributes with Descriptors
    
PARSE the Descriptor File
    Run Keyword If  '${descriptorType}'=='SOL001'    Fetch Information from SOL001 descriptor file    ELSE    Fetch Information from SOL006 descriptor file
    
Fetch Information from SOL001 descriptor file
    @{VDU_labels}=    Create List
    @{VirtualLink_labels}=    Create List
    @{CP_labels}=    Create List
    FOR    ${key}    IN    @{topology_template.node_templates.keys()} 
        ${key_type}=    Get Variable Value    ${topology_template.node_templates.${key}.type}
        ${VDU_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}   ${tosca_type_VDU_compute}
        ${Link_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_virtual_link}
        ${VDUcp_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_VDU_cp}
        Run Keyword If    ${VDU_check}    Append To List    ${VDU_labels}    ${key}
        Run Keyword If    ${Link_check}    Append To List    ${VirtualLink_labels}    ${key}
        Run Keyword If    ${VDUcp_check}    Append To List    ${CP_labels}    ${key}
    END
    Set Global Variable    @{VDU_IDs}    @{VDU_labels}
    Set Global Variable    @{VirtualLink_IDs}    @{VirtualLink_labels}
    Set Global Variable    @{CP_IDs}    @{CP_labels}
    
Fetch Information from SOL006 descriptor file
    ${VDUcount}=    Get Length    ${nfv.vnfd[0].vdu}
    ${extCP_count}=    Get Length    ${nfv.vnfd[0]['ext-cpd']}
    ${virtualLink_count}=    Get length    ${nfv.vnfd[0]['int-virtual-link-desc']}
    FOR    ${key}    IN    @{nfv.vnfd[0].keys()}
        ${VDU_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    vdu
        Run Keyword If    ${VDU_check}    Get VDU IDs    ${VDUcount}
        ${extCP_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    ext-cpd
        Run Keyword If    ${extCP_check}    Get External CP IDs    ${extCP_count}
        ${virtualLink_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    int-virtual-link-desc
        Run Keyword If    ${virtualLink_check}    Get Virtual Link IDs   ${virtualLink_count}    
    END
        
Get VDU IDs
    [Arguments]    ${count}    
    @{VDU_labels}=    Create List
    @{Compute_labels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${VDU_labels}    ${nfv.vnfd[0].vdu[${i}]['id']}
        Append To List    ${Compute_labels}    ${nfv.vnfd[0].vdu[${i}]['virtual-compute-desc']} 
    END
    Set Global Variable    ${VDU_IDs}    ${VDU_labels}
    Set Global Variable    ${Compute_IDs}    ${Compute_labels}
                
Get External CP IDs
    [Arguments]    ${count}    
    @{external_CPs}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${external_CPs}    ${nfv.vnfd[0].ext_cpd[${i}].id} 
    END
    Set Global Variable    ${externalCP_IDs}    ${external_CPs}

Get Virtual Link IDs
    [Arguments]    ${count}    
    ${VirtualLink_labels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${VirtualLink_labels}    ${nfv.vnfd[0]['int-virtual-link-desc'][${i}]['id']} 
    END
    Set Global Variable    ${VirtualLink_IDs}    ${VirtualLink_labels}
    
Match the grant Response Attributes with Descriptors
    Run Keyword If  '${descriptorType}'=='SOL006'    List Should Contain Value    ${externalCP_IDs}    ${response['body']['extVirtualLinks'][0]['extCps'][0]['cpdId']}
    Run Keyword If  '${descriptorType}'=='SOL001'    List Should Contain Value    @{CP_IDs}    ${response['body']['extVirtualLinks'][0]['extCps'][0]['cpdId']}
    List Should Contain Value    ${VirtualLink_IDs}    ${response['body']['extManagedVirtualLinkData'][0]['vnfVirtualLinkDescId']}
    List Should Contain value    ${Compute_IDs}    ${response['body']['vimAssets']['computeResourceFlavours'][0]['vnfdVirtualComputeDescId']}    
