*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           JSONLibrary
Library           OperatingSystem
Resource          NFVMANOCimKeywords.robot
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           MockServerLibrary

*** Test Cases ***
POST Peer Entity
    [Documentation]    Test ID: 8.3.1.8.1
    ...    Test title: POST Peer Entity
    ...    Test objective: The objective is to creates in the producer NFV-MANO functional entity a new peer entity resource which contains configuration and information with regards to the peer functional entity and perform the JSON schema validation of the returned job data structure.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.13.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Peer Entity is created
    Send Post request for Peer Entity
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is    PeerEntity
    Check HTTP Response Header Contains Location
    Check Postcondition Peer Entity Resource is created
    
GET Peer Entities
    [Documentation]    Test ID: 8.3.1.8.2
    ...    Test title: GET Peer Entities
    ...    Test objective: The objective is to query information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities, and perform the JSON schema validation of the returned job data structure.
    ...    Pre-conditions: At least one Peer Entity is already created.
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    Get Peer Entities
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    PeerEntities
    
GET Peer Entities - invalid attribute-based filter
    [Documentation]    Test ID: 8.3.1.8.3
    ...    Test title: GET Peer Entities - invalid attribute-based filter
    ...    Test objective:  The objective is to test that the retrieval of information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities fails when using invalid attribute-based filter, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one Peer Entity is already created. 
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Peer Entities with invalid filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails   
    
GET Peer Entities - invalid attribute selector
    [Documentation]    Test ID: 8.3.1.8.4
    ...    Test title: GET Peer Entities - invalid attribute selector
    ...    Test objective: The objective is to test that the retrieval of information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities fails when using invalid attribute selector, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one Peer Entity is already created. 
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Peer Entities with invalid selector
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails  
    
GET Peer Entities - Bad Request Response too Big
    [Documentation]    Test ID: 8.3.1.8.5
    ...    Test title: GET Peer Entities - Bad Request Response too Big
    ...    Test objective: The objective is to test that the retrieval of information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities fails when response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one Peer Entity is already created. 
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Peer Entities
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET Peer Entities with attribute-based filter
    [Documentation]    Test ID: 8.3.1.8.6
    ...    Test title: GET Peer Entities with attribute-based filter
    ...    Test objective: The objective is to query information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities with attribute filters, and perform the JSON schema validation of the returned job data structure.
    ...    Pre-conditions: At least one Peer Entity is already created. 
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Peer Entities with filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    PeerEntities
    
GET Peer Entities with "all_fields" attribute selector
    [Documentation]    Test ID: 8.3.1.8.7
    ...    Test title: GET Peer Entities with "all_fields" attribute selector
    ...    Test objective: The objective is to retrieve information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities with "all_fields" attribute selector, and perform the JSON schema validation of the returned job data structure.
    ...    Pre-conditions: At least one Peer Entity is already created. 
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Peer Entities with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    PeerEntities
    
GET Peer Entities with "exclude_default" attribute selector
    [Documentation]    Test ID: 8.3.1.8.8
    ...    Test title: GET Peer Entities with "exclude_default" attribute selector
    ...    Test objective: The objective is to retrieve information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities with "exclude_default" attribute selector, and perform the JSON schema validation of the returned job data structure.
    ...    Pre-conditions: At least one Peer Entity is already created. 
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Peer Entities with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    PeerEntities

GET Peer Entities with "fields" attribute selector
    [Documentation]    Test ID: 8.3.1.8.9
    ...    Test title: GET Peer Entities with "fields" attribute selector
    ...    Test objective: The objective is to retrieve information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities with fields attribute selector, and perform the JSON schema validation of the returned job data structure.
    ...    Pre-conditions: At least one Peer Entity is already created. 
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Peer Entities with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    PeerEntities
     
GET Peer Entities with "exclude_fields" attribute selector
    [Documentation]    Test ID: 8.3.1.8.10
    ...    Test title: GET Peer Entities with "exclude_fields" attribute selector
    ...    Test objective: The objective is to retrieve information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities with "exclude_fields" attribute selector, and perform the JSON schema validation of the returned job data structure.
    ...    Pre-conditions: At least one Peer Entity is already created. 
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Peer Entities with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    PeerEntities
    
GET Peer Entities with "exclude_default" and "fields" attribute selector
    [Documentation]    Test ID: 8.3.1.8.11
    ...    Test title: GET Peer Entities with "exclude_default" and "fields" attribute selector
    ...    Test objective: The objective is to retrieve information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities with "exclude_default" and "fields" attribute selector, and perform the JSON schema validation of the returned job data structure.
    ...    Pre-conditions: At least one Peer Entity is already created. 
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Peer Entity with exclude_default and fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    PeerEntities
    
GET Peer Entity with Paged Response
    [Documentation]    Test ID: 8.3.1.8.12
    ...    Test title: GET Peer Entity with Paged Response
    ...    Test objective: The objective is to query information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities to get Paged Response.
    ...    Pre-conditions: At least one Peer Entity is already created.  
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Peer Entities
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains Link
    
Get Peer Entity with malformed authorization token
    [Documentation]    Test ID: 8.3.1.8.13
    ...    Test title: Get Peer Entity with malformed authorization token
    ...    Test objective: The objective is to test that the retrieval of information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities fails when using malformed authorization token.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The Peer Entity requires the usage of access tokens for authorizing the API requests.
    ...    Post-Conditions: none
    GET Peer Entities with malformed authorization token
    Check HTTP Response Status Code Is    401

Get Peer Entity without authorization token
    [Documentation]    Test ID: 8.3.1.8.14
    ...    Test title: Get Peer Entity without authorization token
    ...    Test objective: The objective is to test that the retrieval of information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities fails when omitting the authorization token.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The Peer Entity requires the usage of access tokens for authorizing the API requests.
    ...    Post-Conditions: none
    GET Peer Entities without authorization token
    Check HTTP Response Status Code Is    401

GET information about multiple alarms with expired or revoked authorization token
    [Documentation]    Test ID: 8.3.1.8.15
    ...    Test title: GET information about multiple alarms with expired or revoked authorization token
    ...    Test objective: The objective is to test that the retrieval of information and configuration in the producer NFV-MANO functional entity with regards to multiple peer entities fails when using expired or revoked authorization token.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.13.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The Peer Entity requires the usage of access tokens for authorizing the API requests.
    ...    Post-Conditions: none
    GET Peer Entities with expired or revoked authorization token
    Check HTTP Response Status Code Is    401

PUT Peer Entities - Method not implemented
    [Documentation]    Test ID: 8.3.1.8.16
    ...    Test title: PUT Peer Entities - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.13.3.3 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for Peer Entities
    Check HTTP Response Status Code Is    405
    
PATCH Peer Entities - Method not implemented
    [Documentation]    Test ID: 8.3.1.8.17
    ...    Test title: PATCH Peer Entities - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.13.3.4 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Patch request for Peer Entities
    Check HTTP Response Status Code Is    405

DELETE Peer Entities - Method not implemented
    [Documentation]    Test ID: 8.3.1.8.18
    ...    Test title: DELETE Peer Entities - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.13.3.5 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for Peer Entities
    Check HTTP Response Status Code Is    405
