*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           JSONLibrary
Library           OperatingSystem
Resource          NFVMANOCimKeywords.robot
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           MockServerLibrary

*** Test Cases ***
POST NFV-MANO Service Interfaces - Method not implemented
    [Documentation]    Test ID: 8.3.1.5.1
    ...    Test title: POST NFV-MANO Service Interfaces - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for NFV-MANO Service Interfaces
    Check HTTP Response Status Code Is    405
    
GET NFV-MANO Service Interfaces
    [Documentation]    Test ID: 8.3.1.5.2
    ...    Test title: GET NFV-MANO Service Interfaces
    ...    Test objective: The objective is to query status information about multiple NFV-MANO service interfaces of the NFV-MANO functional entity, and perform the JSON schema validation of the HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    Get NFV-MANO Service Interfaces
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ManoServiceInterfaces
    
GET NFV-MANO Service Interfaces - invalid attribute-based filter
    [Documentation]    Test ID: 8.3.1.5.3
    ...    Test title: GET NFV-MANO Service Interfaces - invalid attribute-based filter
    ...    Test objective:  The objective is to test that the retrieval of NFV-MANO Service Interfaces fails when using invalid attribute-based filter, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NFV-MANO Service Interfaces with invalid filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails   
    
GET NFV-MANO Service Interfaces - invalid attribute selector
    [Documentation]    Test ID: 8.3.1.5.4
    ...    Test title: GET NFV-MANO Service Interfaces - invalid attribute selector
    ...    Test objective: The objective is to test that the retrieval of NFV-MANO Service Interfaces fails when using invalid attribute selector, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NFV-MANO Service Interfaces with invalid selector
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails  
    
GET NFV-MANO Service Interfaces - Bad Request Response too Big
    [Documentation]    Test ID: 8.3.1.5.5
    ...    Test title: GET NFV-MANO Service Interfaces - Bad Request Response too Big
    ...    Test objective: The objective is to test that the retrieval of NFV-MANO Service Interfaces fails when response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NFV-MANO Service Interfaces
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET NFV-MANO Service Interfaces with attribute-based filter
    [Documentation]    Test ID: 8.3.1.5.6
    ...    Test title: GET NFV-MANO Service Interfaces with attribute-based filter
    ...    Test objective: The objective is to query status information about multiple NFV-MANO service interfaces of the NFV-MANO functional entities with attribute filters, and perform the JSON schema validation of the HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NFV-MANO Service Interfaces with filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ManoServiceInterfaces
    
GET NFV-MANO Service Interfaces with "all_fields" attribute selector
    [Documentation]    Test ID: 8.3.1.5.7
    ...    Test title: GET NFV-MANO Service Interface with "all_fields" attribute selector
    ...    Test objective: The objective is to retrieve NFV-MANO Service Interfaces with "all_fields" attribute selector, and perform the JSON schema validation of the HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NFV-MANO Service Interfaces with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ManoServiceInterfaces
    
GET NFV-MANO Service Interfaces with "exclude_default" attribute selector
    [Documentation]    Test ID: 8.3.1.5.8
    ...    Test title: GET NFV-MANO Service Interfaces with "exclude_default" attribute selector
    ...    Test objective: The objective is to retrieve NFV-MANO Service Interfaces with "exclude_default" attribute selector, and perform the JSON schema validation of the HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NFV-MANO Service Interfaces with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ManoServiceInterfaces
   
GET NFV-MANO Service Interfaces with "fields" attribute selector
    [Documentation]    Test ID: 8.3.1.5.9
    ...    Test title: GET NFV-MANO Service Interfaces with "fields" attribute selector
    ...    Test objective: The objective is to retrieve NFV-MANO Service Interfaces with fields attribute selector, and perform the JSON schema validation of the HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NFV-MANO Service Interfaces with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ManoServiceInterfaces
     
GET NFV-MANO Service Interfaces with "exclude_fields" attribute selector
    [Documentation]    Test ID: 8.3.1.5.10
    ...    Test title: GET NFV-MANO Service Interfaces with "exclude_fields" attribute selector
    ...    Test objective: The objective is to retrieve NFV-MANO Service Interfaces with "exclude_fields" attribute selector, and perform the JSON schema validation of the HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NFV-MANO Service Interfaces with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ManoServiceInterfaces
    
GET NFV-MANO Service Interfaces with "exclude_default" and "fields" attribute selector
    [Documentation]    Test ID: 8.3.1.5.11
    ...    Test title: GET NFV-MANO Service Interfaces with "exclude_default" and "fields" attribute selector
    ...    Test objective: The objective is to retrieve NFV-MANO Service Interfaces with "exclude_default" and "fields" attribute selector, and perform the JSON schema validation of the HTTP response.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NFV-MANO Service Interfaces with exclude_default and fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ManoServiceInterfaces
    
GET NFV-MANO Service Interfaces with Paged Response
    [Documentation]    Test ID: 8.3.1.5.12
    ...    Test title: GET NFV-MANO Service Interfaces with Paged Response
    ...    Test objective: The objective is to query NFV-MANO Service Interface to get Paged Response.
    ...    Pre-conditions:  none
    ...    Reference: clause 5.5.10.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NFV-MANO Service Interfaces
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains Link

PUT NFV-MANO Service Interfaces - Method not implemented
    [Documentation]    Test ID: 8.3.1.5.13
    ...    Test title: PUT NFV-MANO Service Interfaces - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.3 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for NFV-MANO Service Interfaces
    Check HTTP Response Status Code Is    405
    
PATCH NFV-MANO Service Interfaces - Method not implemented
    [Documentation]    Test ID: 8.3.1.5.14
    ...    Test title: PATCH NFV-MANO Service Interfaces - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.4 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Patch request for NFV-MANO Service Interfaces
    Check HTTP Response Status Code Is    405

DELETE NFV-MANO Service Interfaces - Method not implemented
    [Documentation]    Test ID: 8.3.1.5.15
    ...    Test title: DELETE NFV-MANO Service Interfaces - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.10.3.5 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for NFV-MANO Service Interfaces
    Check HTTP Response Status Code Is    405