*** Settings ***
Resource    VnfSnapshotPackageManagementKeywords.robot

*** Test Cases ***
POST API Version - Method not implemented
    [Documentation]    Test ID: 5.3.7.1.1
    ...    Test title: POST API version - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.1 - ETSI GS NFV-SOL 013 [5] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none    
    POST API Version
	Check HTTP Response Status Code Is    405
    
GET API Version
    [Documentation]    Test ID: 5.3.7.1.2
    ...    Test title: GET API Version
    ...    Test objective: The objective is to test that GET method successfully return ApiVersionInformation
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.2 - ETSI GS NFV-SOL 013 [5] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    GET API Version
	Check HTTP Response Status Code Is    200
	Check HTTP Response Body Json Schema Is    ApiVersionInformation

PUT API Version - Method not implemented
    [Documentation]    Test ID: 5.3.7.1.3
    ...    Test title: PUT API Version - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.3 - ETSI GS NFV-SOL 013 [5] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT API Version
	Check HTTP Response Status Code Is    405

PATCH API Version - Method not implemented
    [Documentation]    Test ID: 5.3.7.1.4
    ...    Test title: PATCH API Version - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.4 - ETSI GS NFV-SOL 013 [5] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH API Version
	Check HTTP Response Status Code Is    405
    
DELETE API Version - Method not implemented
    [Documentation]    Test ID: 5.3.7.1.5
    ...    Test title: DELETE API Version - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.5 - ETSI GS NFV-SOL 013 [5] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE API Version
	Check HTTP Response Status Code Is    405
	
POST API Version with apiMajorVerion - Method not implemented
    [Documentation]    Test ID: 5.3.7.1.6
    ...    Test title: POST API version with apiMajorVerion - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.1 - ETSI GS NFV-SOL 013 [5] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none    
    POST API Version
	Check HTTP Response Status Code Is    405
    
GET API Version with apiMajorVerion
    [Documentation]    Test ID: 5.3.7.1.7
    ...    Test title: GET API Version with apiMajorVerion
    ...    Test objective: The objective is to test that GET method successfully return ApiVersionInformation
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.2 - ETSI GS NFV-SOL 013 [5] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    GET API Version
	Check HTTP Response Status Code Is    200
	Check HTTP Response Body Json Schema Is    ApiVersionInformation

PUT API Version with apiMajorVerion - Method not implemented
    [Documentation]    Test ID: 5.3.7.1.8
    ...    Test title: PUT API Version with apiMajorVerion - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.3 - ETSI GS NFV-SOL 013 [5] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT API Version
	Check HTTP Response Status Code Is    405

PATCH API Version with apiMajorVerion - Method not implemented
    [Documentation]    Test ID: 5.3.7.1.9
    ...    Test title: PATCH API Version with apiMajorVerion - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.4 - ETSI GS NFV-SOL 013 [5] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH API Version
	Check HTTP Response Status Code Is    405
    
DELETE API Version with apiMajorVerion - Method not implemented
    [Documentation]    Test ID: 5.3.7.1.10
    ...    Test title: DELETE API Version with apiMajorVerion - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 9.3.3.3.5 - ETSI GS NFV-SOL 013 [5] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE API Version
	Check HTTP Response Status Code Is    405