*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           OperatingSystem
Library           JSONLibrary
Library           String
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri
Resource          NSDManagementKeywords.robot

*** Test Cases ***
NSD Onboarding Notification
    [Documentation]    Test ID: 5.3.1.15.1
    ...    Test title: NSD Onboarding Notification
    ...    Test objective: The objective is to test that NSD Onboarding Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A NSD management subscription for onboarding notification is available in the NFVO.
    ...    Reference: Clause 5.4.10.3.1 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post NSD Onboarding Notification
    Check HTTP Response Status Code Is    204
    
NSD Onboarding Failure Notification
    [Documentation]    Test ID: 5.3.1.15.2
    ...    Test title: NSD Onboarding Failure Notification
    ...    Test objective: The objective is to test that NSD Onboarding Failure Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A NSD management subscription for onboarding failure notification is available in the NFVO.
    ...    Reference: Clause 5.4.10.3.1 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post NSD Onboarding Failure Notification
    Check HTTP Response Status Code Is    204
    
NSD Change Notification
    [Documentation]    Test ID: 5.3.1.15.3
    ...    Test title: NSD Change Notification
    ...    Test objective: The objective is to test that NSD Change Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A NSD management subscription for change notification is available in the NFVO.
    ...    Reference: Clause 5.4.10.3.1 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post NSD Change Notification
    Check HTTP Response Status Code Is    204
    
NSD Deletion Notification
    [Documentation]    Test ID: 5.3.1.15.4
    ...    Test title: NSD Deletion Notification
    ...    Test objective: The objective is to test that NSD Deletion Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A NSD management subscription for deletion notification is available in the NFVO.
    ...    Reference: Clause 5.4.10.3.1 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post NSD Deletion Notification
    Check HTTP Response Status Code Is    204
    
Pnfd Onboarding Notification
    [Documentation]    Test ID: 5.3.1.15.5
    ...    Test title: Pnfd Onboarding Notification
    ...    Test objective: The objective is to test that Pnfd Onboarding Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A Pnfd management subscription for onboarding notification is available in the NFVO.
    ...    Reference: Clause 5.4.10.3.1 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Pnfd Onboarding Notification
    Check HTTP Response Status Code Is    204
    
Pnfd Onboarding Failure Notification
    [Documentation]    Test ID: 5.3.1.15.6
    ...    Test title: Pnfd Onboarding Failure Notification
    ...    Test objective: The objective is to test that Pnfd Onboarding Failure Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A Pnfd management subscription for onboarding failure notification is available in the NFVO.
    ...    Reference: Clause 5.4.10.3.1 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Pnfd Onboarding Failure Notification
    Check HTTP Response Status Code Is    204
    
Pnfd Deletion Notification
    [Documentation]    Test ID: 5.3.1.15.7
    ...    Test title: pnfd Deletion Notification
    ...    Test objective: The objective is to test that Pnfd Deletion Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: A Pnfd management subscription for deletion notification is available in the NFVO.
    ...    Reference: Clause 5.4.10.3.1 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Pnfd Deletion Notification
    Check HTTP Response Status Code Is    204
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    Integer    response status    200
    Validate Json    response body    PkgmSubscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

Post NSD Onboarding Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the NS Descriptor File
    ${template} =    Get File    jsons/notifications/NsdOnBoardingNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    nsdInfoId=${nsdInfoId}    nsdId=${NS_DescriptorID}    
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Post NSD Onboarding Failure Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the NS Descriptor File    
    ${template} =    Get File    jsons/notifications/NsdOnBoardingFailureNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    nsdInfoId=${nsdInfoId}    nsdId=${NS_DescriptorID}     
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
Post NSD Change Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the NS Descriptor File        
    ${template} =    Get File    jsons/notifications/NsdChangeNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    nsdInfoId=${nsdInfoId}    nsdId=${NS_DescriptorID} 
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
Post NSD Deletion Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the NS Descriptor File        
    ${template} =    Get File    jsons/notifications/NsdDeletionNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    nsdInfoId=${nsdInfoId}    nsdId=${NS_DescriptorID} 
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
Post Pnfd Onboarding Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/notifications/PnfdOnBoardingNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    pnfdInfoId=${pnfdInfoId} 
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Post Pnfd Onboarding Failure Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/notifications/PnfdOnBoardingFailureNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    pnfdInfoId=${pnfdInfoId} 
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
Post Pnfd Deletion Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/notifications/pnfdDeletionNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    pnfdInfoId=${pnfdInfoId} 
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}