/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.socks;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.socks.SocksAuthResponse;
import io.netty.handler.codec.socks.SocksAuthScheme;
import io.netty.handler.codec.socks.SocksAuthStatus;
import io.netty.handler.codec.socks.SocksCmdRequest;
import io.netty.handler.codec.socks.SocksCmdRequestDecoder;
import io.netty.handler.codec.socks.SocksCmdType;
import io.netty.handler.codec.socks.SocksInitResponse;
import io.netty.handler.codec.socks.SocksRequest;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.socks.SocksConnectHandler;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.mockserver.unification.PortUnificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocksProxyHandler
extends SimpleChannelInboundHandler<SocksRequest> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public SocksProxyHandler() {
        super(false);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, SocksRequest socksRequest) {
        switch (socksRequest.requestType()) {
            case INIT: {
                ctx.pipeline().addFirst(new SocksCmdRequestDecoder());
                ctx.write(new SocksInitResponse(SocksAuthScheme.NO_AUTH));
                break;
            }
            case AUTH: {
                ctx.pipeline().addFirst(new SocksCmdRequestDecoder());
                ctx.write(new SocksAuthResponse(SocksAuthStatus.SUCCESS));
                break;
            }
            case CMD: {
                SocksCmdRequest req = (SocksCmdRequest)socksRequest;
                if (req.cmdType() == SocksCmdType.CONNECT) {
                    Channel channel = ctx.channel();
                    channel.attr(Proxy.PROXYING).set(Boolean.TRUE);
                    if (String.valueOf(req.port()).endsWith("80")) {
                        PortUnificationHandler.disableSslDownstream(channel);
                    } else if (String.valueOf(req.port()).endsWith("443")) {
                        PortUnificationHandler.enabledSslDownstream(channel);
                    }
                    KeyAndCertificateFactory.addSubjectAlternativeName(req.host());
                    ctx.pipeline().addAfter(this.getClass().getSimpleName() + "#0", SocksConnectHandler.class.getSimpleName() + "#0", new SocksConnectHandler(req.host(), req.port()));
                    ctx.pipeline().remove(this);
                    ctx.fireChannelRead(socksRequest);
                    break;
                }
                ctx.close();
                break;
            }
            case UNKNOWN: {
                ctx.close();
            }
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.shouldIgnoreException(cause)) {
            this.logger.warn("Exception caught by SOCKS proxy handler -> closing pipeline " + ctx.channel(), cause);
        }
        ctx.close();
    }
}

