/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mockserver.collections.CircularLinkedList;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class MockServerMatcher
extends ObjectWithReflectiveEqualsHashCodeToString {
    protected final List<HttpRequestMatcher> httpRequestMatchers = Collections.synchronizedList(new CircularLinkedList(ConfigurationProperties.maxExpectations()));
    private MatcherBuilder matcherBuilder;

    public MockServerMatcher(LoggingFormatter logFormatter) {
        this.matcherBuilder = new MatcherBuilder(logFormatter);
    }

    public synchronized void add(Expectation expectation) {
        this.httpRequestMatchers.add(this.matcherBuilder.transformsToMatcher(expectation));
    }

    private synchronized List<HttpRequestMatcher> cloneMatchers() {
        return new ArrayList<HttpRequestMatcher>(this.httpRequestMatchers);
    }

    public synchronized void reset() {
        this.httpRequestMatchers.clear();
    }

    public Expectation firstMatchingExpectation(HttpRequest httpRequest) {
        Expectation matchingExpectation = null;
        for (HttpRequestMatcher httpRequestMatcher : this.cloneMatchers()) {
            if (httpRequestMatcher.matches(httpRequest)) {
                matchingExpectation = httpRequestMatcher.decrementRemainingMatches();
            }
            if (!httpRequestMatcher.isActive() && this.httpRequestMatchers.contains(httpRequestMatcher)) {
                this.httpRequestMatchers.remove(httpRequestMatcher);
            }
            if (matchingExpectation == null) continue;
            break;
        }
        return matchingExpectation;
    }

    public void clear(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpRequestMatcher clearHttpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (HttpRequestMatcher httpRequestMatcher : this.cloneMatchers()) {
                if (!clearHttpRequestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest(), false) || !this.httpRequestMatchers.contains(httpRequestMatcher)) continue;
                this.httpRequestMatchers.remove(httpRequestMatcher);
            }
        } else {
            this.reset();
        }
    }

    public List<Expectation> retrieveExpectations(HttpRequest httpRequest) {
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        for (HttpRequestMatcher httpRequestMatcher : this.cloneMatchers()) {
            if (httpRequest != null && !httpRequestMatcher.matches(httpRequest)) continue;
            expectations.add(httpRequestMatcher.getExpectation());
        }
        return expectations;
    }
}

