/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchType;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;

public class JsonStringMatcher
extends BodyMatcher<String> {
    private final String matcher;
    private final MatchType matchType;

    public JsonStringMatcher(String matcher, MatchType matchType) {
        this.matcher = matcher;
        this.matchType = matchType;
    }

    @Override
    public boolean matches(String matched) {
        boolean result = false;
        try {
            JSONCompareResult jsonCompareResult;
            JSONCompareMode jsonCompareMode = JSONCompareMode.LENIENT;
            if (this.matchType == MatchType.STRICT) {
                jsonCompareMode = JSONCompareMode.STRICT;
            }
            if ((jsonCompareResult = JSONCompare.compareJSON(this.matcher, matched, jsonCompareMode)).passed()) {
                result = true;
            }
            if (!result) {
                this.logger.trace("Failed to perform JSON match \"{}\" with \"{}\" because {}", matched, this.matcher, jsonCompareResult.getMessage());
            }
        }
        catch (Exception e) {
            this.logger.trace("Failed to perform JSON match \"{}\" with \"{}\" because {}", matched, this.matcher, e.getMessage());
        }
        return this.reverseResultIfNot(result);
    }
}

