/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.junit;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockserver.client.proxy.ProxyClient;
import org.mockserver.integration.ClientAndProxy;
import org.mockserver.socket.PortFactory;

public class ProxyRule
implements TestRule {
    private static ClientAndProxy perTestSuiteClientAndProxy;
    private final Object target;
    private final Integer port;
    private final boolean perTestSuite;
    private ClientAndProxyFactory clientAndProxyFactory;
    private ClientAndProxy clientAndProxy;

    public ProxyRule(Object target) {
        this(PortFactory.findFreePort(), target);
    }

    public ProxyRule(Object target, boolean perTestSuite) {
        this(PortFactory.findFreePort(), target, perTestSuite);
    }

    public ProxyRule(Integer port, Object target) {
        this(port, target, false);
    }

    public ProxyRule(Integer port, Object target, boolean perTestSuite) {
        this.port = port;
        this.target = target;
        this.perTestSuite = perTestSuite;
        this.clientAndProxyFactory = new ClientAndProxyFactory(port);
    }

    public Integer getHttpPort() {
        return this.port;
    }

    @Override
    public Statement apply(Statement base, Description description) {
        return this.statement(base);
    }

    private Statement statement(final Statement base) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void evaluate() throws Throwable {
                if (ProxyRule.this.perTestSuite) {
                    if (perTestSuiteClientAndProxy == null) {
                        perTestSuiteClientAndProxy = ProxyRule.this.clientAndProxyFactory.newClientAndProxy();
                        Runtime.getRuntime().addShutdownHook(new Thread(){

                            @Override
                            public void run() {
                                perTestSuiteClientAndProxy.stop();
                            }
                        });
                    }
                    ProxyRule.this.clientAndProxy = perTestSuiteClientAndProxy;
                } else {
                    ProxyRule.this.clientAndProxy = ProxyRule.this.clientAndProxyFactory.newClientAndProxy();
                }
                ProxyRule.this.setProxyClient(ProxyRule.this.target, ProxyRule.this.clientAndProxy);
                try {
                    base.evaluate();
                }
                finally {
                    if (!ProxyRule.this.perTestSuite) {
                        ProxyRule.this.clientAndProxy.stop();
                    }
                }
            }
        };
    }

    private void setProxyClient(Object target, ClientAndProxy clientAndProxy) {
        Class<?> clazz = target.getClass();
        while (!clazz.equals(Object.class)) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.getType().equals(ProxyClient.class)) continue;
                field.setAccessible(true);
                try {
                    field.set(target, clientAndProxy);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Error setting ProxyClient field on " + target.getClass().getName(), e);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    public ProxyClient getClient() {
        return this.clientAndProxy;
    }

    @VisibleForTesting
    class ClientAndProxyFactory {
        private final Integer port;

        public ClientAndProxyFactory(Integer port) {
            this.port = port;
        }

        public ClientAndProxy newClientAndProxy() {
            return ClientAndProxy.startClientAndProxy(this.port);
        }
    }
}

