/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.filters;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.log.model.ExpectationLogEntry;
import org.mockserver.log.model.ExpectationMatchLogEntry;
import org.mockserver.log.model.LogEntry;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.log.model.RequestLogEntry;
import org.mockserver.log.model.RequestResponseLogEntry;
import org.mockserver.logging.LoggingFormatter;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;

public class LogFilter {
    private static final List<Class<? extends LogEntry>> MESSAGE_LOG_TYPES = Collections.singletonList(MessageLogEntry.class);
    private static final List<Class<? extends LogEntry>> REQUEST_LOG_TYPES = Arrays.asList(RequestLogEntry.class, RequestResponseLogEntry.class, ExpectationMatchLogEntry.class);
    private static final List<Class<? extends LogEntry>> EXPECTATION_LOG_TYPES = Arrays.asList(RequestResponseLogEntry.class, ExpectationMatchLogEntry.class);
    static Predicate<LogEntry> messageLogPredicate = new Predicate<LogEntry>(){

        @Override
        public boolean apply(LogEntry input) {
            return MESSAGE_LOG_TYPES.contains(input.getClass());
        }
    };
    private static Function<LogEntry, HttpRequest> logEntryToRequest = new Function<LogEntry, HttpRequest>(){

        @Override
        public HttpRequest apply(LogEntry logEntry) {
            return logEntry.getHttpRequest();
        }
    };
    static Predicate<LogEntry> requestLogPredicate = new Predicate<LogEntry>(){

        @Override
        public boolean apply(LogEntry input) {
            return REQUEST_LOG_TYPES.contains(input.getClass());
        }
    };
    private static Function<LogEntry, Expectation> logEntryToExpectation = new Function<LogEntry, Expectation>(){

        @Override
        public Expectation apply(LogEntry logEntry) {
            return ((ExpectationLogEntry)((Object)logEntry)).getExpectation();
        }
    };
    static Predicate<LogEntry> expectationLogPredicate = new Predicate<LogEntry>(){

        @Override
        public boolean apply(LogEntry input) {
            return EXPECTATION_LOG_TYPES.contains(input.getClass());
        }
    };
    public static Predicate<LogEntry> notMessageLogEntryPredicate = new Predicate<LogEntry>(){

        @Override
        public boolean apply(LogEntry logEntry) {
            return !(logEntry instanceof MessageLogEntry);
        }
    };
    private final LoggingFormatter logFormatter;
    private Queue<LogEntry> requestLog = Queues.synchronizedQueue(EvictingQueue.create(100));
    private MatcherBuilder matcherBuilder;
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private Function<LogEntry, String> logEntryToMessage = new Function<LogEntry, String>(){

        @Override
        public String apply(LogEntry logEntry) {
            MessageLogEntry messageLogEntry = (MessageLogEntry)logEntry;
            return messageLogEntry.getMessage();
        }
    };

    public LogFilter(LoggingFormatter logFormatter) {
        this.logFormatter = logFormatter;
        this.matcherBuilder = new MatcherBuilder(logFormatter);
    }

    public void onRequest(LogEntry logEntry) {
        this.requestLog.add(logEntry);
    }

    public void reset() {
        this.requestLog.clear();
    }

    public void clear(HttpRequest request) {
        if (request != null) {
            HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(request);
            for (LogEntry logEntry : new LinkedList<LogEntry>(this.requestLog)) {
                if (!requestMatcher.matches(logEntry.getHttpRequest(), false)) continue;
                this.requestLog.remove(logEntry);
            }
        } else {
            this.reset();
        }
    }

    public List<String> retrieveMessages(HttpRequest httpRequest) {
        return this.retrieveLogEntries(httpRequest, messageLogPredicate, this.logEntryToMessage);
    }

    public List<HttpRequest> retrieveRequests(HttpRequest httpRequest) {
        return this.retrieveLogEntries(httpRequest, requestLogPredicate, logEntryToRequest);
    }

    public List<Expectation> retrieveExpectations(HttpRequest httpRequest) {
        return this.retrieveLogEntries(httpRequest, expectationLogPredicate, logEntryToExpectation);
    }

    <T> List<T> retrieveLogEntries(HttpRequest httpRequest, Predicate<LogEntry> logEntryPredicate, Function<LogEntry, T> logEntryToTypeFunction) {
        ArrayList<T> matchingLogEntries = new ArrayList<T>();
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (LogEntry logEntry : new LinkedList<LogEntry>(this.requestLog)) {
            if (!logEntryPredicate.apply(logEntry) || !httpRequestMatcher.matches(logEntry.getHttpRequest(), false)) continue;
            matchingLogEntries.add(logEntryToTypeFunction.apply(logEntry));
        }
        return matchingLogEntries;
    }

    public String verify(Verification verification) {
        LinkedList<LogEntry> requestLog = new LinkedList<LogEntry>(this.requestLog);
        String failureMessage = "";
        if (verification != null) {
            List<HttpRequest> matchingRequests = this.retrieveRequests(verification.getHttpRequest());
            boolean verified = true;
            if (verification.getTimes().getCount() != 0 && matchingRequests.isEmpty()) {
                verified = false;
            } else if (verification.getTimes().isExact() && matchingRequests.size() != verification.getTimes().getCount()) {
                verified = false;
            } else if (matchingRequests.size() < verification.getTimes().getCount()) {
                verified = false;
            }
            if (!verified) {
                List<HttpRequest> allRequestsArray = this.retrieveRequests(null);
                String serializedRequestToBeVerified = this.httpRequestSerializer.serialize(true, verification.getHttpRequest());
                String serializedAllRequestInLog = allRequestsArray.size() == 1 ? this.httpRequestSerializer.serialize(true, allRequestsArray.get(0)) : this.httpRequestSerializer.serialize(true, allRequestsArray);
                this.logFormatter.infoLog(verification.getHttpRequest(), "request not found " + verification.getTimes() + ", expected:{}" + Character.NEW_LINE + " but was:{}", serializedRequestToBeVerified, serializedAllRequestInLog);
                failureMessage = "Request not found " + verification.getTimes() + ", expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
            }
        }
        return failureMessage;
    }

    public String verify(VerificationSequence verificationSequence) {
        LinkedList<LogEntry> requestLog = new LinkedList<LogEntry>(this.requestLog);
        String failureMessage = "";
        if (verificationSequence != null) {
            int requestLogCounter = 0;
            for (HttpRequest verificationHttpRequest : verificationSequence.getHttpRequests()) {
                if (verificationHttpRequest == null) continue;
                HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verificationHttpRequest);
                boolean foundRequest = false;
                while (!foundRequest && requestLogCounter < requestLog.size()) {
                    LogEntry logEntry = requestLog.get(requestLogCounter);
                    if (!(logEntry instanceof MessageLogEntry) && httpRequestMatcher.matches(logEntry.getHttpRequest(), false)) {
                        foundRequest = true;
                    }
                    ++requestLogCounter;
                }
                if (foundRequest) continue;
                List<HttpRequest> allRequestsArray = this.retrieveRequests(null);
                String serializedRequestToBeVerified = this.httpRequestSerializer.serialize(true, verificationSequence.getHttpRequests());
                String serializedAllRequestInLog = allRequestsArray.size() == 1 ? this.httpRequestSerializer.serialize(true, allRequestsArray.get(0)) : this.httpRequestSerializer.serialize(true, allRequestsArray);
                failureMessage = "Request sequence not found, expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
                this.logFormatter.infoLog(verificationSequence.getHttpRequests(), "request sequence not found, expected:{}" + Character.NEW_LINE + " but was:{}", serializedRequestToBeVerified, serializedAllRequestInLog);
                break;
            }
        }
        return failureMessage;
    }
}

