/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerStringListParser {
    private Logger logger = LoggerFactory.getLogger(IntegerStringListParser.class);

    public Integer[] toArray(String integers) {
        List<Integer> integerList = this.toList(integers);
        return integerList.toArray(new Integer[integerList.size()]);
    }

    public List<Integer> toList(String integers) {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        for (String integer : Splitter.on(",").split(integers)) {
            try {
                integerList.add(Integer.parseInt(integer.trim()));
            }
            catch (NumberFormatException nfe) {
                this.logger.error("NumberFormatException converting " + integer + " to integer", nfe);
            }
        }
        return integerList;
    }

    public String toString(Integer[] integers) {
        return this.toString(Arrays.asList(integers));
    }

    public String toString(List<Integer> integers) {
        return Joiner.on(",").join(integers);
    }
}

