/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.util.CRLFOutputStream;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;
import org.bouncycastle.util.Strings;

public class SMIMEUtil {
    private static final String MULTIPART = "multipart";
    private static final int BUF_SIZE = 32760;

    public static boolean isMultipartContent(Part part) throws MessagingException {
        String string = Strings.toLowerCase(part.getContentType());
        return string.startsWith(MULTIPART);
    }

    static boolean isCanonicalisationRequired(MimeBodyPart mimeBodyPart, String string) throws MessagingException {
        String[] stringArray = mimeBodyPart.getHeader("Content-Transfer-Encoding");
        String string2 = stringArray == null ? string : stringArray[0];
        return !string2.equalsIgnoreCase("binary");
    }

    static void outputPreamble(LineOutputStream lineOutputStream, MimeBodyPart mimeBodyPart, String string) throws MessagingException, IOException {
        String string2;
        InputStream inputStream;
        try {
            inputStream = mimeBodyPart.getRawInputStream();
        }
        catch (MessagingException messagingException) {
            return;
        }
        while ((string2 = SMIMEUtil.readLine(inputStream)) != null && !string2.equals(string)) {
            lineOutputStream.writeln(string2);
        }
        inputStream.close();
        if (string2 == null) {
            throw new MessagingException("no boundary found");
        }
    }

    static void outputPostamble(LineOutputStream lineOutputStream, MimeBodyPart mimeBodyPart, int n, String string) throws MessagingException, IOException {
        String string2;
        InputStream inputStream;
        try {
            inputStream = mimeBodyPart.getRawInputStream();
        }
        catch (MessagingException messagingException) {
            return;
        }
        int n2 = n + 1;
        while (!((string2 = SMIMEUtil.readLine(inputStream)) == null || string2.startsWith(string) && --n2 == 0)) {
        }
        while ((string2 = SMIMEUtil.readLine(inputStream)) != null) {
            lineOutputStream.writeln(string2);
        }
        inputStream.close();
        if (n2 != 0) {
            throw new MessagingException("all boundaries not found for: " + string);
        }
    }

    static void outputPostamble(LineOutputStream lineOutputStream, BodyPart bodyPart, String string, BodyPart bodyPart2) throws MessagingException, IOException {
        String string2;
        InputStream inputStream;
        try {
            inputStream = ((MimeBodyPart)bodyPart).getRawInputStream();
        }
        catch (MessagingException messagingException) {
            return;
        }
        MimeMultipart mimeMultipart = (MimeMultipart)bodyPart2.getContent();
        ContentType contentType = new ContentType(mimeMultipart.getContentType());
        String string3 = "--" + contentType.getParameter("boundary");
        int n = mimeMultipart.getCount() + 1;
        while (n != 0 && (string2 = SMIMEUtil.readLine(inputStream)) != null) {
            if (!string2.startsWith(string3)) continue;
            --n;
        }
        while ((string2 = SMIMEUtil.readLine(inputStream)) != null && !string2.startsWith(string)) {
            lineOutputStream.writeln(string2);
        }
        inputStream.close();
    }

    private static String readLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) >= 0 && n != 10) {
            if (n == 13) continue;
            stringBuffer.append((char)n);
        }
        if (n < 0 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    static void outputBodyPart(OutputStream outputStream, boolean bl, BodyPart bodyPart, String string) throws MessagingException, IOException {
        if (bodyPart instanceof MimeBodyPart) {
            int n;
            Object object;
            InputStream inputStream;
            MimeBodyPart mimeBodyPart = (MimeBodyPart)bodyPart;
            String[] stringArray = mimeBodyPart.getHeader("Content-Transfer-Encoding");
            if (SMIMEUtil.isMultipartContent(mimeBodyPart)) {
                Object object2 = bodyPart.getContent();
                Multipart multipart = object2 instanceof Multipart ? (Multipart)object2 : new MimeMultipart(bodyPart.getDataHandler().getDataSource());
                ContentType contentType = new ContentType(multipart.getContentType());
                String string2 = "--" + contentType.getParameter("boundary");
                LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
                Enumeration enumeration = mimeBodyPart.getAllHeaderLines();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    lineOutputStream.writeln(string3);
                }
                lineOutputStream.writeln();
                SMIMEUtil.outputPreamble(lineOutputStream, mimeBodyPart, string2);
                for (int i = 0; i < multipart.getCount(); ++i) {
                    lineOutputStream.writeln(string2);
                    BodyPart bodyPart2 = multipart.getBodyPart(i);
                    SMIMEUtil.outputBodyPart(outputStream, false, bodyPart2, string);
                    if (!SMIMEUtil.isMultipartContent(bodyPart2)) {
                        lineOutputStream.writeln();
                        continue;
                    }
                    SMIMEUtil.outputPostamble(lineOutputStream, (BodyPart)mimeBodyPart, string2, bodyPart2);
                }
                lineOutputStream.writeln(string2 + "--");
                if (bl) {
                    SMIMEUtil.outputPostamble(lineOutputStream, mimeBodyPart, multipart.getCount(), string2);
                }
                return;
            }
            String string4 = stringArray == null ? string : stringArray[0];
            if (!string4.equalsIgnoreCase("base64") && !string4.equalsIgnoreCase("quoted-printable")) {
                if (!string4.equalsIgnoreCase("binary")) {
                    outputStream = new CRLFOutputStream(outputStream);
                }
                bodyPart.writeTo(outputStream);
                outputStream.flush();
                return;
            }
            boolean bl2 = string4.equalsIgnoreCase("base64");
            try {
                inputStream = mimeBodyPart.getRawInputStream();
            }
            catch (MessagingException messagingException) {
                outputStream = new CRLFOutputStream(outputStream);
                bodyPart.writeTo(outputStream);
                outputStream.flush();
                return;
            }
            LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
            Object object3 = mimeBodyPart.getAllHeaderLines();
            while (object3.hasMoreElements()) {
                object = (String)object3.nextElement();
                lineOutputStream.writeln((String)object);
            }
            lineOutputStream.writeln();
            lineOutputStream.flush();
            object3 = bl2 ? new Base64CRLFOutputStream(outputStream) : new CRLFOutputStream(outputStream);
            object = new byte[32760];
            while ((n = inputStream.read((byte[])object, 0, ((Object)object).length)) > 0) {
                ((OutputStream)object3).write((byte[])object, 0, n);
            }
            inputStream.close();
            ((OutputStream)object3).flush();
        } else {
            if (!string.equalsIgnoreCase("binary")) {
                outputStream = new CRLFOutputStream(outputStream);
            }
            bodyPart.writeTo(outputStream);
            outputStream.flush();
        }
    }

    public static MimeBodyPart toMimeBodyPart(byte[] byArray) throws SMIMEException {
        return SMIMEUtil.toMimeBodyPart(new ByteArrayInputStream(byArray));
    }

    public static MimeBodyPart toMimeBodyPart(InputStream inputStream) throws SMIMEException {
        try {
            return new MimeBodyPart(inputStream);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception creating body part.", messagingException);
        }
    }

    static FileBackedMimeBodyPart toWriteOnceBodyPart(CMSTypedStream cMSTypedStream) throws SMIMEException {
        try {
            return new WriteOnceFileBackedMimeBodyPart(cMSTypedStream.getContentStream(), File.createTempFile("bcMail", ".mime"));
        }
        catch (IOException iOException) {
            throw new SMIMEException("IOException creating tmp file:" + iOException.getMessage(), iOException);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("can't create part: " + messagingException, messagingException);
        }
    }

    public static FileBackedMimeBodyPart toMimeBodyPart(CMSTypedStream cMSTypedStream) throws SMIMEException {
        try {
            return SMIMEUtil.toMimeBodyPart(cMSTypedStream, File.createTempFile("bcMail", ".mime"));
        }
        catch (IOException iOException) {
            throw new SMIMEException("IOException creating tmp file:" + iOException.getMessage(), iOException);
        }
    }

    public static FileBackedMimeBodyPart toMimeBodyPart(CMSTypedStream cMSTypedStream, File file) throws SMIMEException {
        try {
            return new FileBackedMimeBodyPart(cMSTypedStream.getContentStream(), file);
        }
        catch (IOException iOException) {
            throw new SMIMEException("can't save content to file: " + iOException, iOException);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("can't create part: " + messagingException, messagingException);
        }
    }

    public static IssuerAndSerialNumber createIssuerAndSerialNumberFor(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            return new IssuerAndSerialNumber(new JcaX509CertificateHolder(x509Certificate).getIssuer(), x509Certificate.getSerialNumber());
        }
        catch (Exception exception) {
            throw new CertificateParsingException("exception extracting issuer and serial number: " + exception);
        }
    }

    static class Base64CRLFOutputStream
    extends FilterOutputStream {
        protected int lastb = -1;
        protected static byte[] newline = new byte[2];
        private boolean isCrlfStream;

        public Base64CRLFOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(int n) throws IOException {
            if (n == 13) {
                this.out.write(newline);
            } else if (n == 10) {
                if (this.lastb != 13) {
                    if (!this.isCrlfStream || this.lastb != 10) {
                        this.out.write(newline);
                    }
                } else {
                    this.isCrlfStream = true;
                }
            } else {
                this.out.write(n);
            }
            this.lastb = n;
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            for (int i = n; i != n + n2; ++i) {
                this.write(byArray[i]);
            }
        }

        public void writeln() throws IOException {
            this.out.write(newline);
        }

        static {
            Base64CRLFOutputStream.newline[0] = 13;
            Base64CRLFOutputStream.newline[1] = 10;
        }
    }

    static class LineOutputStream
    extends FilterOutputStream {
        private static byte[] newline = new byte[2];

        public LineOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void writeln(String string) throws MessagingException {
            try {
                byte[] byArray = LineOutputStream.getBytes(string);
                this.out.write(byArray);
                this.out.write(newline);
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        public void writeln() throws MessagingException {
            try {
                this.out.write(newline);
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        private static byte[] getBytes(String string) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)cArray[n2++];
            }
            return byArray;
        }

        static {
            LineOutputStream.newline[0] = 13;
            LineOutputStream.newline[1] = 10;
        }
    }

    private static class WriteOnceFileBackedMimeBodyPart
    extends FileBackedMimeBodyPart {
        public WriteOnceFileBackedMimeBodyPart(InputStream inputStream, File file) throws MessagingException, IOException {
            super(inputStream, file);
        }

        public void writeTo(OutputStream outputStream) throws MessagingException, IOException {
            super.writeTo(outputStream);
            this.dispose();
        }
    }
}

