*** Settings ***
Resource    environment/variables.txt 

Library    OperatingSystem
Library    Collections
Library    REST     http://localhost:8080    ssl_verify=false


*** Keywords ***
Trigger instrumentation platform    
     [Arguments]    ${upperTesterUrl}    ${resourceId}    ${resourceType}    ${event}    ${value}    &{keyvalues}
     ${alarmNotificationBoolean}    Run Keyword And Return Status    Should Be Equal As Strings    ${event}    AlarmNotification        
     ${alarmClearedNotificationBoolean}    Run Keyword And Return Status    Should Be Equal As Strings    ${event}    AlarmClearedNotification        
     ${alarmListRebuiltNotificationBoolean}    Run Keyword And Return Status    Should Be Equal As Strings    ${event}    AlarmListRebuiltNotification        
     Run Keyword If    ${alarmNotificationBoolean} == True or ${alarmClearedNotificationBoolean} == True or ${alarmListRebuiltNotificationBoolean} == True
     ...    Trigger Alarm Management UpperTester     ${upperTesterUrl}    ${resourceId}    ${resourceType}    ${event}    ${value}    &{keyvalues}
     
    
Trigger Alarm Management UpperTester
    [Arguments]    ${upperTesterUrl}    ${resourceId}    ${resourceType}    ${event}    ${value}    &{keyvalues}
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE_UPPERTESTER} == 1    Set Headers    {"${AUTHORIZATION_HEADER_UPPERTESTER}":"${AUTHORIZATION_TOKEN_UPPERTESTER}"}
    ${template}=    Get File    ../../instrumentationPlatformHooks/jsons/AlarmNotificationUpperTester.json
    ${body}=        Format String   ${template}     resourceId=${resourceId}    resourceType=${resourceType}   event=${event}    value=${value}     keyvalues=${keyvalues}
    POST    ${upperTesterUrl}       ${body}
    ${output}=    Output    response
    Should Be Equal As Strings    ${output['status']}    202