*** Settings ***
Resource    environment/variables.txt
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false 
Library    MockServerLibrary 
Library    OperatingSystem
Library    BuiltIn
Library    JSONLibrary
Library    Collections
Library    JSONSchemaLibrary    schemas/
Library    RequestsLibrary
Library    Process
Library    String

*** Keywords ***
Send Post Request for coordination of an LCM operation occurrence
    Log    Requesting a new coordination task for an LCM Operation occurrence
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    ${template}=    Get File    jsons/createLcmCoordRequest.json
    ${body}=        Format String    ${template}    nsInstanceId=${nsInstanceId}    nsLcmOpOccId=${nsLcmOpOccId}    lcmOperationType=${lcmOperationType}    coordinationActionName=${coordinationActionName}    nsLcmOpOccHref=${nsLcmOpOccHref}    nsInstanceHref=${nsInstanceHref}     
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.POST    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 
    

Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Run Keyword If    '${input}' == 'ProblemDetails'    Should Contain    ${response['headers']['Content-Type']}    application/problem+json
    ...    ELSE    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Log     ${response['body']}
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK  
    

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings     ${response['status']}    ${expected_status}
    Log    Status code validated
    

Check Postcondition LcmCoord Exists
    Log    Checking that individual lcm coordination exists
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.GET    ${apiRoot}/${apiName}/${apiMajorVersion}/coordiations/${response['body']['id']}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    LcmCoord
    

Send Post Request for coordination of an LCM operation occurrence - forbidden
    Log    Requesting a new coordination task for an LCM Operation occurrence
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    ${template}=    Get File    jsons/createLcmCoordRequest.json
    ${body}=        Format String    ${template}    nsInstanceId=${nsInstanceId}    nsLcmOpOccId=${nsLcmOpOccId}    lcmOperationType=${lcmOperationType}    coordinationActionName=${coordinationActionName}    nsLcmOpOccHref=${nsLcmOpOccHref}    nsInstanceHref=${nsInstanceHref}     
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${INSUFFICIENT_AUTHORIZATION_TOKEN}"}
    REST.POST    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 

Send Post Request for coordination of an LCM operation occurrence - conflict
    Log    Requesting a new coordination task for an LCM Operation occurrence not in PROCESSING state
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    ${template}=    Get File    jsons/createLcmCoordRequest.json
    ${body}=        Format String    ${template}    nsInstanceId=${nsInstanceId}    nsLcmOpOccId=${nsLcmOpOccIdNotProcessing}    lcmOperationType=${lcmOperationType}    coordinationActionName=${coordinationActionName}    nsLcmOpOccHref=${nsLcmOpOccHrefNotProcessing}    nsInstanceHref=${nsInstanceHref}     
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.POST    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    

Send Post Request for coordination of an LCM operation occurrence synchronously - service unavailable
    Log    Requesting a new coordination task for an LCM Operation occurrence when API producer
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    ${template}=    Get File    jsons/createLcmCoordRequest.json
    ${body}=        Format String    ${template}    nsInstanceId=${nsInstanceId}    nsLcmOpOccId=${nsLcmOpOccIdServiceUnavailable}    lcmOperationType=${lcmOperationType}    coordinationActionName=${coordinationActionName}    nsLcmOpOccHref=${nsLcmOpOccHrefServiceUnavailable}    nsInstanceHref=${nsInstanceHref}     
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.POST    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    


Send Post Request for coordination of an LCM operation occurrence without authorization token
    Log    Requesting a new coordination task for an LCM Operation occurrence without authorization token
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    ${body}=    Get File    jsons/createLcmCoordRequest.json
    REST.POST    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 
    
   
GET all Coordinations of an LCM operation occurrence
    Log    Requesting the retrieve of all coordination tasks 
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.GET    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
PUT all Coordinations of an LCM operation occurrence
    Log    Requesting the update of all coordination tasks 
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    

PATCH all Coordinations of an LCM operation occurrence
    Log    Requesting the update of all coordination tasks 
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}


DELETE all Coordinations of an LCM operation occurrence
    Log    Requesting the removal of all coordination tasks 
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
 
Retrieve information about a finished coordination task   
    Log    Requesting the retrieve of a finished coordination task
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.GET    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${coordinationId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
 
 
Retrieve information about an ongoing coordination task   
    Log    Requesting the retrieve of an ongoing coordination task
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.GET    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${ongoingCoordinationId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 
    

Retrieve information about an invalid coordination task   
    Log    Requesting the retrieve of an invalid coordination task
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.GET    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${erroneousCoordinationId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
POST an individual Coordination of an LCM operation occurrence
    Log    Requesting the creation of an individual coordination action task 
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.POST    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${coordinationId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
PUT an individual coordination action of an LCM operation occurrence
    Log    Requesting the update of an individual coordination action task 
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${coordinationId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    

PATCH an individual coordination action of an LCM operation occurrence
    Log    Requesting the update of an individual coordination action task
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${coordinationId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}


DELETE an individual coordination action of an LCM operation occurrence
    Log    Requesting the removal of an individual coordination action task
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${coordinationId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}


Send Post Request for cancellation of an ongoing coordination action
    Log    Requesting the cancellation of an ongoing coordination task
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.POST    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${ongoingCoordinationId}/cancel
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post Request for cancellation of a finished coordination action
    Log    Requesting the cancellation of a finished coordination task
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.POST    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${finishedCoordinationActionId}/cancel
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    

Send Post Request for cancellation of an ongoing coordination action without authorization token
    Log    Requesting the cancellation of an ongoing coordination task without authorization
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    REST.POST    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${ongoingCoordinationId}/cancel
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
        
GET information about a cancellation of an ongoing coordination action
    Log    Requesting information about a cancellation of an ongoing coordination action
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.GET    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${ongoingCoordinationId}/cancel
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
PUT information about a cancellation of an ongoing coordination action
    Log    Update information about a cancellation of an ongoing coordination action
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${ongoingCoordinationId}/cancel
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
PATCH information about a cancellation of an ongoing coordination action
    Log    Update information about a cancellation of an ongoing coordination action
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${ongoingCoordinationId}/cancel
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
DELETE information about a cancellation of an ongoing coordination action
    Log    Terminate a cancellation task related to an ongoing coordination action
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${NFVO_AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    REST.DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/coordinations/${ongoingCoordinationId}/cancel
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}