*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Library           JSONLibrary
Library           REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false

*** Test Cases ***
Get Individual Performance Report
    [Documentation]    Test ID: 6.3.3.3.1
    ...    Test title: Get Individual Performance Report
    ...    Test objective: The objective is to test the retrieval of an individual VNF performance report associated to a monitoring job and perform a JSON schema validation of the collected report data structure
    ...    Pre-conditions: A VNF instance is instantiated. One or more VNF performance reports are set for a monitoring job in the VNFM.
    ...    Reference: Clause 6.4.4.3.2 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Individual Performance Report
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PerformanceReport

Get Individual Performance Report with invalid resource endpoint
        [Documentation]    Test ID: 6.3.3.3.2
    ...    Test title: Get Individual Performance Report with invalid resource endpoint
    ...    Test objective:  The objective is to test that the retrieval of an individual VNF performance report associated to a monitoring job fails when using an invalid resource endpoint 
    ...    Pre-conditions: A VNF instance is instantiated. One or more VNF performance reports are set for a monitoring job in the VNFM.
    ...    Reference: Clause 6.4.4.3.2 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Individual Performance Report with invalid resource endpoint
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

POST Individual Performance Report - Method not implemented
    [Documentation]    Test ID: 6.3.3.3.3
    ...    Test title: POST Individual Performance Report - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new VNF performance report within a monitoring job
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.4.3.1 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for Individual Performance Report
    Check HTTP Response Status Code Is    405

PUT Individual Performance Report - Method not implemented
    [Documentation]    Test ID: 6.3.3.3.4
    ...    Test title: PUT Individual Performance Report - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update an existing VNF performance report within a monitoring job
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.4.3.3 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for Individual Performance Report
    Check HTTP Response Status Code Is    405

PATCH Individual Performance Report - Method not implemented
    [Documentation]    Test ID: 6.3.3.3.5
    ...    Test title: PATCH Individual Performance Report - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to modify an existing VNF performance report within a monitoring job
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.4.3.4 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Patch request for Individual Performance Report
    Check HTTP Response Status Code Is    405

DELETE Individual Performance Report - Method not implemented
    [Documentation]    Test ID: 6.3.3.3.6
    ...    Test title: DELETE Individual Performance Report - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to delete an existing VNF performance report within a monitoring job
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.4.3.5 - ETSI GS NFV-SOL 002 [2] v2.7.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for Individual Performance Report
    Check HTTP Response Status Code Is    405

*** Keywords ***
Get Individual Performance Report
    Log    Trying to get a performance report present in the VNFM
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Get Individual Performance Report with invalid resource endpoint
    Log    Trying to get a performance report with invalid resource endpoint
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${erroneousReportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post request for Individual Performance Report
    Log    Trying to create new performance report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${newReportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Put request for Individual Performance Report
    Log    Trying to update performance report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch request for Individual Performance Report
    Log    Trying to update performance report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for Individual Performance Report
    Log    Trying to delete performance report   
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Check Postcondition VNF Individual Performance Report Exists
    Log    Checking that report still exists
    Get Individual Performance Report

Check Postcondition VNF Individual Performance Report is not Created
    Log    Trying to get a new report
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${newReportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    ${status}=    Convert To Integer    ${expected_status}    
    Should Be Equal    ${response['status']}    ${status} 
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}	.schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK

