*** Settings ***
Documentation     This Clause defines the "cancel" operation related to an individual coordination action for the NS LCM Coordination interface
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Resource          NSLCMCoordKeywords.robot
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library           OperatingSystem

*** Test Cases ***
Request a cancellation of an ongoing coordination action 
    [Documentation]    Test ID: 5.3.8.4.1
    ...    Test title:  Request a cancellation of an ongoing coordination action
    ...    Test objective: The objective is to test the request for the cancellation of an ongoing coordination task
    ...    Pre-conditions: An ongoing coordination action is available
    ...    Reference: Clause 12.4.4.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none 
    Send Post Request for cancellation of an ongoing coordination action
    Check HTTP Response Status Code Is    202


Request a cancellation of a finished coordination action 
    [Documentation]    Test ID: 5.3.8.4.2
    ...    Test title: Request a cancellation of a finished coordination action
    ...    Test objective: The objective is to test the request for the cancellation of a finished coordination action
    ...    Pre-conditions: A finished coordination action is available
    ...    Reference: Clause 12.4.4.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none 
    Send Post Request for cancellation of a finished coordination action
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails
 

Request a cancellation of an ongoing coordination action without authentication
    [Documentation]    Test ID: 5.3.8.4.3
    ...    Test title: Request a cancellation of an ongoing coordination action without authentication
    ...    Test objective: The objective is to test the failure of the request for a cancellation of a coordination task when no authentication is used
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.4.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post Request for cancellation of an ongoing coordination action without authorization token
    Check HTTP Response Status Code Is    401
    

GET information about a cancellation of an ongoing coordination action - method not implemented
    [Documentation]    Test ID: 5.3.8.4.4
    ...    Test title: GET information about a cancellation of an ongoing coordination action - method not implemented
    ...    Test objective: The objective is to test that the GET method is not allowed to retrieve cancellation details of an ongoing coordination action
    ...    Pre-conditions: A cancellation task has been activated
    ...    Reference: Clause 12.4.4.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    GET information about a cancellation of an ongoing coordination action
    Check HTTP Response Status Code Is    405


PUT information about a cancellation of an ongoing coordination action - method not implemented
    [Documentation]    Test ID: 5.3.8.4.5
    ...    Test title: PUT information about a cancellation of an ongoing coordination action - method not implemented
    ...    Test objective: The objective is to test that the PUT method is not allowed to modify cancellation details of an ongoing coordination action
    ...    Pre-conditions: A cancellation task has been activated
    ...    Reference: Clause 12.4.4.3.3 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT information about a cancellation of an ongoing coordination action
    Check HTTP Response Status Code Is    405


PATCH information about a cancellation of an ongoing coordination action - method not implemented
    [Documentation]    Test ID: 5.3.8.4.6
    ...    Test title: PATCH information about a cancellation of an ongoing coordination action - method not implemented
    ...    Test objective: he objective is to test that the PATCH method is not allowed to modify cancellation details of an ongoing coordination action
    ...    Pre-conditions: A cancellation task has been activated
    ...    Reference: Clause 12.4.4.3.4 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH information about a cancellation of an ongoing coordination action
    Check HTTP Response Status Code Is    405


DELETE information about a cancellation of an ongoing coordination action - method not implemented
    [Documentation]    Test ID: 5.3.8.4.7
    ...    Test title: DELETE information about a cancellation of an ongoing coordination action - method not implemented
    ...    Test objective: The objective is to test that the DELETE method is not allowed to remove cancellation details of an ongoing coordination action
    ...    Pre-conditions: A cancellation task has been activated
    ...    Reference: Clause 12.4.4.3.5 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE information about a cancellation of an ongoing coordination action
    Check HTTP Response Status Code Is    405