*** Settings ***
Resource    environment/variables.txt  
Library     REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}     ssl_verify=false
Library     DependencyLibrary
Library     JSONLibrary
Library     JSONSchemaLibrary    schemas/
Library     String
Library     OperatingSystem
Library     Collections

*** Keywords ***
POST API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PUT API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PATCH API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PUT API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PATCH API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
	
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings   ${response['status']}    ${expected_status}
    Log    Status code validated 

Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK
    
POST VNF Snapshot Packages
    Log    Trying to create a VNF Snapshot Package using the POST method.
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/CreateVnfSnapshotPkgInfoRequest.json
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        
	
GET multiple VNF Snapshot Packages	
    Log    Query VNF The GET method queries information about multiple VNF Snapshot Packages.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 		

GET multiple VNF Snapshot Packages with bad attribute	
    Log    Query VNF The GET method queries information about multiple VNF Snapshot Packages.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?attribute_not_exist=some_value
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

GET multiple VNF Snapshot Packages with bad filter	
    Log    Query VNF The GET method queries information about multiple VNF Snapshot Packages.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?${filter_ko}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
	
GET multiple VNF Snapshot Packages using filter	
    Log    Query VNF The GET method queries information about multiple VNF Snapshot Packages using filter
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?${filter_ok}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET multiple VNF Snapshot Packages with all_fields attribute selector
    Log    Query status information about multiple VNF Snapshot Packages, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?all_fields
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET multiple VNF Snapshot Packages with exclude_default attribute selector
    Log    Query status information about multiple VNF Snapshot Packages using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET multiple VNF Snapshot Packages with fields attribute selector
    Log    Query status information about multiple VNF Snapshot Packages, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}	    
    
GET multiple VNF Snapshot Packages with exclude_default and fields attribute selector
    Log    Query status information about multiple VNF Snapshot Packages, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?fields=${fields}&exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET multiple VNF Snapshot Packages with exclude_fields attribute selector
    Log    Query status information about multiple VNF Snapshot Packages, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?exclude_fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 	

GET VNF Snapshot Packages without Paging support
    Run Keyword If    ${PAGING_SUPPORTED} == 0    GET multiple VNF Snapshot Packages
    
GET VNF Snapshot Packages with Paging support
    Run Keyword If    ${PAGING_SUPPORTED} == 1    GET multiple VNF Snapshot Packages

Check HTTP Response Header Contains Link
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}

PUT VNF Snapshot Packages
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages   	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH VNF Snapshot Packages
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE VNF Snapshot Packages
    Log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}   

POST individual VNF Snapshot Package
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}    
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

GET individual VNF Snapshot Package
    log    Trying to get information about an individual VNF Snapshot Package
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      

GET individual VNF Snapshot Package with invalid URI
    log    Trying to get information about an individual VNF Snapshot Package
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${invalidVnfSnapshotPkgId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      
	
PUT individual VNF Snapshot Package
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
    
PATCH individual VNF Snapshot Package
    log    Trying to modify a VNF Snapshot Package using PATCH method
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/VnfSnapshotPkgInfoModifications.json
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
Check state of the VNF Snapshot Package - PATCH
    GET individual VNF Snapshot Package
    ${state}=    Get variable value    ${response['body']['state']}
    @{error_states_VnfSnapshotPackage}=    Create List
    Append to List   ${error_states_VnfSnapshotPackage}    ERROR    BUILDING    UPLOADING    EXTRACTING
    List should contain value    ${error_states_VnfSnapshotPackage}    ${state}

PATCH individual VNF Snapshot Package - Erroneous State
    Check state of the VNF Snapshot Package - PATCH
    log    Trying to modify a VNF Snapshot Package which is in state other than CREATED, ERROR_EXTRACTING or AVAILABLE
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/VnfSnapshotPkgInfoModifications.json
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

Check state of the VNF Snapshot Package - DELETE
    GET individual VNF Snapshot Package
    ${state}=    Get variable value    ${response['body']['state']}
    @{error_states_VnfSnapshotPackage}=    Create List
    Append to List   ${error_states_VnfSnapshotPackage}    ERROR_EXTRACTING    BUILDING    UPLOADING    EXTRACTING
    List should contain value    ${error_states_VnfSnapshotPackage}    ${state}

DELETE individual VNF Snapshot Package
    log    Trying to DELETE an individual VNF Snapshot package
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE individual VNF Snapshot Package - Conflict
    Check state of the VNF Snapshot Package - DELETE
    log    Trying to DELETE an individual VNF Snapshot package which is in state other than ERROR, CREATED or AVAILABLE
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST VNF Snapshot Package Content
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_ZIP}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content   
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

GET VNF Snapshot Package Content - Complete
    log    Trying to fetch the complete contents of VNF Snapshot Package
    Set Headers    {"Accept":"${ACCEPT_ZIP}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

GET VNF Snapshot Package Content - Range Request
    Pass Execution If    ${NFVO_RANGE_OK} == 0    Skipping this test as NFVO is not able to handle partial Requests.
    log    Trying to get information about an individual VNF Snapshot Package using a range request
    Set Headers    {"Accept":"${ACCEPT_ZIP}"}  
    Set Headers    {"Range":"${range}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

GET VNF Snapshot Package Content - Invalid Range
    Pass Execution If    ${NFVO_RANGE_OK} == 0    Skipping this test as NFVO is not able to handle partial Requests.
    log    Trying to get information about an individual VNF Snapshot Package with invalid range
    Set Headers    {"Accept":"${ACCEPT_ZIP}"}  
    Set Headers    {"Range":"${erroneousRange}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
GET VNF Snapshot Package Content - Not Available 
    Check State of VNF Package - Not AVAILABLE
    Log    Trying to fetch the contents of a VNF Snapshot Package which is not in AVAILABLE state
    Set Headers    {"Accept":"${ACCEPT_ZIP}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId_notInAvailableState}/package_content 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
Check State of VNF Package - Not AVAILABLE
    GET individual VNF Snapshot Package
    ${state}=    Get variable value    ${response['body']['state']}
    Should not be equal as strings    ${state}    AVAILABLE

Check HTTP Content-Type Header Is Set For Package Content
    Log    Check Content-Type HTTP Header
    Should Contain    ${response['headers']}    Content-Type
    Should Be Equal As Strings    ${response['headers']['Content-Type']}    ${CONTENT_TYPE_ZIP} 
    Log    Content type validated

Check HTTP Content-Range Header Is Set
    Log    Check Content-Range HTTP Header
    Should Contain    ${response['headers']}    Content-Range
    Should Be Equal As Strings    ${response['headers']['Content-Range']}    ${range}/${full_length}
    Log    Header Content-Range is present
    
Check HTTP Content-Length Header Is Set
    Log    Check Content-Length HTTP Header
    Should Contain    ${response['headers']}    Content-Lenght
    Should Be Equal As Strings    ${response['headers']['Content-Length']}    ${full_length}
    Log    Header Content-Length is present

PUT VNF Snapshot Package Content
    log    Trying to upload the contents of VNF Snapshot Package using PUT
    Set Headers  {"Accept":"${ACCEPT_ZIP}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_ZIP}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get Binary File    zip/sampleVNFSnapshotPackage.zip
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content    ${body} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PUT VNF Snapshot Package Content - Conflict
    Check Conflict State for PUT VNF Snapshot Package Content
    log    Trying to upload the contents of VNF Snapshot Package using PUT when the state of Individual VNF Snapshot Package is other than CREATED or ERROR
    Set Headers  {"Accept":"${ACCEPT_ZIP}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_ZIP}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get Binary File    zip/sampleVNFSnapshotPackage.zip
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content    ${body} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
Check Conflict State for PUT VNF Snapshot Package Content
    GET individual VNF Snapshot Package
    ${state}=    Get variable value    ${response['body']['state']}
    @{allowedStates_VnfSnapshotPackage}=    Create List
    Append to List   ${allowedStates_VnfSnapshotPackage}    ERROR    CREATED
    List should not contain value    ${allowedStates_VnfSnapshotPackage}    ${state}
	
PATCH VNF Snapshot Package Content
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_ZIP}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_ZIP}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE VNF Snapshot Package Content
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_ZIP}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

POST Individual VNF Snapshot Package Artifact
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_OCTET}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_OCTET}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath}   
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

GET Individual VNF Snapshot Package Artifact - Complete
    log    Trying to fetch the complete contents of an individual VNF Snapshot Package artifact
    Set Headers    {"Accept":"${ACCEPT_OCTET}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

GET Individual VNF Snapshot Package Artifact - Range Request
    Pass Execution If    ${NFVO_RANGE_OK} == 0    Skipping this test as NFVO is not able to handle partial Requests.
    log    Trying to get information about an individual VNF Snapshot Package artifact using a range request
    Set Headers    {"Accept":"${ACCEPT_OCTET}"}  
    Set Headers    {"Range":"${range}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

GET Individual VNF Snapshot Package Artifact - Invalid Range
    Pass Execution If    ${NFVO_RANGE_OK} == 0    Skipping this test as NFVO is not able to handle partial Requests.
    log    Trying to get information about an individual VNF Snapshot Package artifact with invalid range
    Set Headers    {"Accept":"${CONTENT_TYPE_OCTET}"}  
    Set Headers    {"Range":"${erroneousRange}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
GET Individual VNF Snapshot Package Artifact - Not Available 
    Check Conflict State for Extract VNF Snapshot Package Content
    Log    Trying to get information about an individual artifact of a VNF Snapshot Package which is not in AVAILABLE state
    Set Headers    {"Accept":"${ACCEPT_OCTET}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId_notInAvailableState}/artifacts/${artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
GET Individual VNF Snapshot Package Artifact - External
    log    Trying to fetch information about an external VNF Snapshot artifact
    Set Headers    {"Accept":"${ACCEPT_OCTET}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${ext_artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

PUT Individual VNF Snapshot Package Artifact
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_OCTET}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_OCTET}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH Individual VNF Snapshot Package Artifact
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_OCTET}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_OCTET}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE Individual VNF Snapshot Package Artifact
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_OCTET}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

Check HTTP Response Contains Resource URI
    ${ResourceURI}=    Get Value From Json    ${response['headers']}    $..Location
    Should Not Be Empty    ${ResourceURI}

Check HTTP Content-Type Header Is Set For Package Artifact
    Log    Check Content-Type HTTP Header
    Should Contain    ${response['headers']}    Content-Type
    Should Be Equal As Strings    ${response['headers']['Content-Type']}    ${CONTENT_TYPE_OCTET} 
    Log    Content type validated

POST Upload VNF Snapshot Package Content from URI
    Log    Trying to initiate Upload VNF Snapshot Content from URI task
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/UploadVnfSnapshotPkgFromUriRequest.json
    ${body}=        Format String   ${template}    addressInformation=${vnfPackageContent_URI}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/upload_from_uri    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        
    
POST Upload VNF Snapshot Package Content from URI - Conflict
    Check Conflict State for PUT VNF Snapshot Package Content
    Log    Trying to initiate Upload VNF Snapshot Content from URI task when the state of the VNF Snapshot Package is other than ERROR or CREATED.
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/UploadVnfSnapshotPkgFromUriRequest.json
    ${body}=        Format String   ${template}    addressInformation=${vnfPackageContent_URI}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/upload_from_uri    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        
    
GET Upload VNF Snapshot Package Content from URI
    log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/upload_from_uri 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PUT Upload VNF Snapshot Package Content from URI
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/upload_from_uri 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH Upload VNF Snapshot Package Content from URI
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/upload_from_uri 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE Upload VNF Snapshot Package Content from URI
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/upload_from_uri 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST Build VNF Snapshot Package Content Task
    Log    Trying to initiate the Build of VNF Snapshot Content Task
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/BuildVnfSnapshotPkgRequest.json
    ${body}=        Format String   ${template}    vnfSnapshotInfoId=${vnfSnapshotInfoId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/build    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        
    
POST Build VNF Snapshot Package Content Task - Conflict
    Check Conflict State for BUILD VNF Snapshot Package Content
    Log    Trying to initiate the Build VNF Snapshot Content task when the state of the VNF Snapshot Package is not CREATED.
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/BuildVnfSnapshotPkgRequest.json
    ${body}=        Format String   ${template}    vnfSnapshotInfoId=${vnfSnapshotInfoId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/build    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}    
	
Check Conflict State for BUILD VNF Snapshot Package Content
    GET individual VNF Snapshot Package
    ${state}=    Get variable value    ${response['body']['state']}
    Should not be equal as strings    ${state}    CREATED
          
GET Build VNF Snapshot Package Content Task
    log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/build 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PUT Build VNF Snapshot Package Content Task
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/build 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH Build VNF Snapshot Package Content Task
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/build 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE Build VNF Snapshot Package Content Task
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/build 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST Extract VNF Snapshot Package Content Task
    Log    Trying to initiate Extract VNF Snapshot Content from URI task
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/ExtractVnfSnapshotPkgRequest.json
    ${body}=        Format String   ${template}    vnfSnapshotInfoId=${vnfSnapshotInfoId}    
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/extract    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        
    
POST Extract VNF Snapshot Package Content Task - Conflict State
    Check Conflict State for Extract VNF Snapshot Package Content
    Log    Trying to initiate the Extract VNF Snapshot Content task when the state of the VNF Snapshot Package is not AVAILABLE.
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/ExtractVnfSnapshotPkgRequest.json
    ${body}=        Format String   ${template}    vnfSnapshotInfoId=${vnfSnapshotInfoId}    vnfInstanceId=${vnfInstanceId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/extract    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

Check Conflict State for Extract VNF Snapshot Package Content
    GET individual VNF Snapshot Package
    ${state}=    Get variable value    ${response['body']['state']}
    Should not be equal as strings    ${state}    AVAILABLE
          
POST Extract VNF Snapshot Package Content Task - Invalid vnfInstanceId
    Log    Trying to initiate the Extract VNF Snapshot Content task when the state of the VNF Snapshot Package is not AVAILABLE.
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/ExtractVnfSnapshotPkgRequest.json
    ${body}=        Format String   ${template}    vnfSnapshotInfoId=${vnfSnapshotInfoId}    vnfInstanceId=${invalidVnfInstanceId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/extract    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        
    
GET Extract VNF Snapshot Package Content Task
    log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/extract 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PUT Extract VNF Snapshot Package Content Task
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/extract 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH Extract VNF Snapshot Package Content Task
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/extract 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE Extract VNF Snapshot Package Content Task
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/extract 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST Cancel VNF Snapshot Package Content Task
    Log    Trying to initiate cancelation of VNF Snapshot Content Task
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/CancelVnfSnapshotPkgOperationRequest.json
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/cancel    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        
    
POST Cancel VNF Snapshot Package Content Task - Conflict
    Check Conflict State for Cancel VNF Snapshot Package Content
    Log    Trying to initiate the cancelation of VNF Snapshot Content task when the state of the VNF Snapshot Package is other than "UPLOADING", "BUILDING", "PROCESSING" or "EXTRACTING".
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/CancelVnfSnapshotPkgOperationRequest.json
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/cancel    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}    
	
Check Conflict State for Cancel VNF Snapshot Package Content
    GET individual VNF Snapshot Package
    ${state}=    Get variable value    ${response['body']['state']}
    @{allowedStates}=    Create List
    Append to List   ${allowedStates}    PROCESSING    BUILDING    UPLOADING    EXTRACTING
    List should not contain value    ${allowedStates}    ${state}

GET Cancel VNF Snapshot Package Content Task
    log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/cancel 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PUT Cancel VNF Snapshot Package Content Task
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/cancel 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH Cancel VNF Snapshot Package Content Task
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/cancel 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE Cancel VNF Snapshot Package Content Task
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content/cancel 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST Access Configuration for External Artifacts
    Log    Trying to perform a POST. This method should not be implemented.
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/ext_artifacts_access
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

PUT Access Configuration for External Artifacts
    Log    Trying to provide the access configuration information to the NFVO using PUT method.
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/VnfSnapshotPkgExtArtifactsAccessInfo.json
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/ext_artifacts_access    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}    
    
PUT Access Configuration for External Artifacts - Conflict
    Check Conflict State for Cancel VNF Snapshot Package Content
    Log    Trying to provide the access configuration information to the NFVO using PUT method when the state of VNF Snapshot Package is not ERROR or CREATED.
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/VnfSnapshotPkgExtArtifactsAccessInfo.json
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/ext_artifacts_access    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}    
	
Check Conflict State for External Artifact Access Configuration
    GET individual VNF Snapshot Package
    ${state}=    Get variable value    ${response['body']['state']}
    @{allowedStates}=    Create List
    Append to List   ${allowedStates}    CREATED    ERROR
    List should not contain value    ${allowedStates}    ${state}

GET Access Configuration for External Artifacts
    log    Trying to read the access configuration information that is used by the NFVO to get the content of external VNF snapshot package artifacts
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/ext_artifacts_access 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH Access Configuration for External Artifacts
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/ext_artifacts_access 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE Access Configuration for External Artifacts
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/ext_artifacts_access 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 