*** Settings ***
Library    String
Library    OperatingSystem
Resource    environment/variables.txt
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}        ssl_verify=false
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
VNF LCM Operation Occurrence Notification
    [Documentation]    Test ID: 7.3.1.36.1
    ...    Test title: VNF LCM Operation Occurrence Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF LCM Operation Occurrence Notification.
    ...    Pre-conditions: A subscription for VNF LCM Operation Occurrence notifications is available in the VNFM.
    ...    Reference: Clause 5.4.20.3.1 - ETSI GS NFV-SOL 003 [1] v3.5.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF LCM Operation Occurrence Notification
    Check HTTP Response Status Code Is    204
    
VNF Identifier Creation Notification
    [Documentation]    Test ID: 7.3.1.36.2
    ...    Test title: VNF Identifier Creation Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF Identifier Creation Notification.
    ...    Pre-conditions: A subscription for VNF identifier creation cotification is available in the VNFM.
    ...    Reference: Clause 5.4.20.3.1 - ETSI GS NFV-SOL 003 [1] v3.5.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Identifier Creation Notification
    Check HTTP Response Status Code Is    204

VNF Identifier Deletion Notification
    [Documentation]    Test ID: 7.3.1.36.3
    ...    Test title: VNF Identifier Deletion Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF Identifier Deletion Notification.
    ...    Pre-conditions: A subscription for VNF identifier deletion notifications is available in the VNFM.
    ...    Reference: Clause 5.4.20.3.1 - ETSI GS NFV-SOL 003 [1] v3.5.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF LCM Operation Occurrence Notification
    Check HTTP Response Status Code Is    204
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}	
    Integer    response status    200
    Validate Json    response body    Subscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 

Post VNF LCM Operation Occurrence Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/VnfLcmOperationOccurrenceNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    vnfInstanceId=${vnfInstanceId}    vnfLcmOpOccId=${vnfLcmOpOccId}   
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
	
Post VNF Identifier Creation Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/VnfIdentifierCreationNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    vnfInstanceId=${vnfInstanceId}  
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
	
Post VNF Identifier Deletion Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/VnfIdentifierDeletionNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    vnfInstanceId=${vnfInstanceId}  
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	