*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Library           JSONLibrary
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           OperatingSystem
Resource          environment/individualThresholds.txt

*** Test Cases ***
POST Individual Threshold - Method not implemented
    [Documentation]    Test ID: 8.3.2.5.1
    ...    Test title: POST Individual Threshold - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new Performance Threshold
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.7.3.1 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for individual Performance Threshold
    Check HTTP Response Status Code Is    405
    
GET Individual Threshold
    [Documentation]    Test ID: 8.3.2.5.2
    ...    Test title: GET Individual Threshold
    ...    Test objective: The objective is to test the retrieval of an individual NFV-MANO performance threshold and perform a JSON schema and content validation of the collected threshold data structure
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance thresholds are set.
    ...    Reference: clause 6.5.7.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual Performance Threshold
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   Threshold
    Check HTTP Response Body Threshold Identifier matches the requested Threshold

GET Individual Threshold with invalid resource identifier
    [Documentation]    Test ID: 8.3.2.5.3
    ...    Test title: GET Individual Threshold with invalid resource identifier
    ...    Test objective: The objective is to test that the retrieval of an individual performance threshold fails when using an invalid resource identifier
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance jobs are set.
    ...    Reference: clause 6.5.7.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual Performance Threshold with invalid resource identifier
    Check HTTP Response Status Code Is    404

PUT Individual Threshold - Method not implemented
    [Documentation]    Test ID: 8.3.2.5.4
    ...    Test title: PUT Individual Threshold - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update an existing Performance threshold
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.7.3.3 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for individual Performance Threshold
    Check HTTP Response Status Code Is    405

PATCH Individual Threshold - Method not implemented
    [Documentation]    Test ID: 8.3.2.5.5
    ...    Test title: PATCH Individual Threshold - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to modify an existing Performance threshold
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.7.3.4 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Patch request for individual Performance Threshold
    Check HTTP Response Status Code Is    405
    
DELETE Individual Threshold
    [Documentation]    Test ID: 8.3.2.5.6
    ...    Test title: DELETE Individual Threshold
    ...    Test objective: The objective is to test the deletion of an individual performance threshold
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance thresholds are set.
    ...    Reference: clause 6.5.7.3.5 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The Performance Threshold is not available anymore in the NFV-MANO    
    Send Delete request for individual Performance Threshold
    Check HTTP Response Status Code Is    204
    Check Postcondition Performance Threshold is Deleted

DELETE Individual Threshold with invalid resource identifier
    [Documentation]    Test ID: 8.3.2.5.7
    ...    Test title: DELETE Individual Threshold with invalid resource identifier
    ...    Test objective: The objective is to test the deletion of an individual performance threshold
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more performance thresholds are set.
    ...    Reference: clause 6.5.7.3.5 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none   
    Send Delete request for individual Performance Threshold with invalid resource identifier
    Check HTTP Response Status Code Is    404

*** Keywords ***
GET Individual Performance Threshold
    Log    Trying to get a Threhsold present in the NFV-MANO
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

GET individual Performance Threshold with invalid resource identifier
    Log    Trying to get a Threhsold with invalid resource endpoint
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${erroneousThresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Delete request for individual Performance Threshold
    Log    Trying to delete a Threhsold in the NFV-MANO
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Delete request for individual Performance Threshold with invalid resource identifier
    Log    Trying to delete a Threhsold in the NFV-MANO with invalid id
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${erroneousThresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Post request for individual Performance Threshold
    Log    Trying to create new threshold
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${newThresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Put request for individual Performance Threshold
    Log    Trying to PUT threshold
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Patch request for individual Performance Threshold
    Log    Trying to PUT threshold
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Check Postcondition Performance Threshold is Deleted
    Log    Check Postcondition Threshold is deleted
    GET individual Performance Threshold
    Check HTTP Response Status Code Is    404
    
Check HTTP Response Body Threshold Identifier matches the requested Threshold
    Log    Trying to check response ID
    Should Be Equal    ${response['body']['id']}    ${thresholdId} 
    Log    Pm Job identifier as expected
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    ${status}=    Convert To Integer    ${expected_status}    
    Should Be Equal    ${response['status']}    ${status} 
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Run Keyword If    '${input}' == 'ProblemDetails'    Should Contain    ${response['headers']['Content-Type']}    application/problem+json
    ...    ELSE    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK
