** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           JSONLibrary
Library           OperatingSystem
Resource          NFVMANOCimKeywords.robot
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           MockServerLibrary

*** Test Cases ***
POST Individual Change State Operation Occurrence - Method not implemented
    [Documentation]    Test ID: 8.3.1.4.1
    ...    Test title: POST Individual Change State Operation Occurrence - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.9.3.1 - ETSI GS NFV-SOL 009 [6] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for Individual Change State Operation Occurrence
    Check HTTP Response Status Code Is    405
    
GET Individual Change State Operation Occurrence
    [Documentation]    Test ID: 8.3.1.4.2
    ...    Test title: GET Individual Change State Operation Occurrence
    ...    Test objective: The objective is to query status information about Individual change state operation occurrence.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.9.3.2 - ETSI GS NFV-SOL 009 [6] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    Get Individual Change State Operation Occurrence
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ChangeStateOpOcc
    
GET Individual Change State Operation Occurrence - Not Found
    [Documentation]    Test ID: 8.3.1.4.3
    ...    Test title: GET Individual Change State Operation Occurrence - Not Found
    ...    Test objective: The objective is to test the retrieval of information about individual change state operation occurence fails when the resource is not present.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.9.3.2 - ETSI GS NFV-SOL 009 [6] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Individual Change State Operation Occurrence
    Check HTTP Response Status Code Is    404
    
PUT Individual Change State Operation Occurrence - Method not implemented
    [Documentation]    Test ID: 8.3.1.4.4
    ...    Test title: PUT Individual Change State Operation Occurrence - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.9.3.3 - ETSI GS NFV-SOL 009 [6] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for Individual Change State Operation Occurrence
    Check HTTP Response Status Code Is    405
    
PATCH Individual Change State Operation Occurrence - Method not implemented
    [Documentation]    Test ID: 8.3.1.4.5
    ...    Test title: PATCH Individual Change State Operation Occurrence - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.9.3.4 - ETSI GS NFV-SOL 009 [6] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Patch request for Individual Change State Operation Occurrence
    Check HTTP Response Status Code Is    405

DELETE Individual Change State Operation Occurrence - Method not implemented
    [Documentation]    Test ID: 8.3.1.4.6
    ...    Test title: DELETE Individual Change State Operation Occurrence - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.9.3.5 - ETSI GS NFV-SOL 009 [6] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for Individual Change State Operation Occurrence
    Check HTTP Response Status Code Is    405