/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import java.util.UUID;
import org.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.callback.WebSocketRequestCallback;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.mock.action.HttpForwardAction;
import org.mockserver.mock.action.HttpForwardActionResult;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.responsewriter.ResponseWriter;

public class HttpForwardObjectCallbackActionHandler
extends HttpForwardAction {
    private WebSocketClientRegistry webSocketClientRegistry;

    public HttpForwardObjectCallbackActionHandler(HttpStateHandler httpStateHandler, NettyHttpClient httpClient) {
        super(httpStateHandler.getMockServerLogger(), httpClient);
        this.webSocketClientRegistry = httpStateHandler.getWebSocketClientRegistry();
    }

    public void handle(final ActionHandler actionHandler, final HttpObjectCallback httpObjectCallback, HttpRequest request, final ResponseWriter responseWriter, final boolean synchronous) {
        String clientId = httpObjectCallback.getClientId();
        String webSocketCorrelationId = UUID.randomUUID().toString();
        this.webSocketClientRegistry.registerCallbackHandler(webSocketCorrelationId, new WebSocketRequestCallback(){

            @Override
            public void handle(HttpRequest request) {
                HttpForwardActionResult responseFuture = HttpForwardObjectCallbackActionHandler.this.sendRequest(request.removeHeader("WebSocketCorrelationId"), null);
                actionHandler.writeForwardActionResponse(responseFuture, responseWriter, request, httpObjectCallback, synchronous);
            }
        });
        this.webSocketClientRegistry.sendClientMessage(clientId, request.clone().withHeader("WebSocketCorrelationId", webSocketCorrelationId));
    }
}

