*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Resource          VNFPackageManagementKeywords.robot    
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false

*** Test Cases ***
Void
     [Documentation]    Test ID: 5.3.5.3.1
    ...    Test title: Void
    ...    Test objective: Void
    ...    Pre-conditions: Void
    ...    Reference: Void
    ...    Config ID: Void
    ...    Applicability: Void
    ...    Post-Conditions: Void
    Void

Get VNFD in Individual VNF Package in Zip Format
    [Documentation]    Test ID: 5.3.5.3.2
    ...    Test title: Get VNFD in Individual VNF Package in Zip Format
    ...    Test objective: The objective is to test the retrieval of the VNFD in zip format for an individual VNF package and perform a validation that returned content is in zip format
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4.3.2 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get VNFD in Individual VNF Package in Zip Format
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip

Void
     [Documentation]    Test ID: 5.3.5.3.3
    ...    Test title: Void
    ...    Test objective: Void
    ...    Pre-conditions: Void
    ...    Reference: Void
    ...    Config ID: Void
    ...    Applicability: Void
    ...    Post-Conditions: Void
    Void
    
Void
     [Documentation]    Test ID: 5.3.5.3.4
    ...    Test title: Void
    ...    Test objective: Void
    ...    Pre-conditions: Void
    ...    Reference: Void
    ...    Config ID: Void
    ...    Applicability: Void
    ...    Post-Conditions: Void
    Void
    
Void
     [Documentation]    Test ID: 5.3.5.3.5
    ...    Test title: Void
    ...    Test objective: Void
    ...    Pre-conditions: Void
    ...    Reference: Void
    ...    Config ID: Void
    ...    Applicability: Void
    ...    Post-Conditions: Void
    Void
    
Get VNFD in Individual VNF Package with invalid resource identifier
    [Documentation]    Test ID: 5.3.5.3.6
    ...    Test title: Get VNFD in Individual VNF Package with invalid resource identifier
    ...    Test objective: The objective is to test that the retrieval of the VNFD for an individual VNF Package fails when using an invalid resource identifier
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.4.3.2 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get VNFD in Individual VNF Package with invalid resource identifier
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

Get VNFD in Individual VNF Package with conflict due to onboarding state
    [Documentation]    Test ID: 5.3.5.3.7
    ...    Test title: Get VNFD in Individual VNF Package with conflict due to onboarding state
    ...    Test objective: The objective is to test that the retrieval of the VNFD for an individual VNF Package fails due to a conflict when the VNF Package is not in onboarding state ONBOARDED in the NFVO. The test also performs a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: The onboarding state of the VNF package for which the VNFD is requested is different from ONBOARDED.
    ...    Reference: Clause 9.4.4.3.2 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get VNFD in Individual VNF Package with conflict due to onboarding state
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails

POST VNFD in Individual VNF Package - Method not implemented
    [Documentation]    Test ID: 5.3.5.3.8
    ...    Test title: POST VNFD in Individual VNF Package - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create new VNFD
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.4.3.1 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send POST Request for VNFD in individual VNF Package
    Check HTTP Response Status Code Is    405

PUT VNFD in Individual VNF Package - Method not implemented
    [Documentation]    Test ID: 5.3.5.3.9
    ...    Test title: PUT VNFD in Individual VNF Package - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to modify a VNFD
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4.3.3 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request for VNFD in individual VNF Package
    Check HTTP Response Status Code Is    405

PATCH VNFD in Individual VNF Package - Method not implemented
    [Documentation]    Test ID: 5.3.5.3.10
    ...    Test title: PATCH VNFD in Individual VNF Package - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update a VNFD
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4.3.4 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for VNFD in individual VNF Package
    Check HTTP Response Status Code Is    405

DELETE VNFD in Individual VNF Package - Method not implemented
    [Documentation]    Test ID: 5.3.5.3.11
    ...    Test title: DELETE VNFD in Individual VNF Package - Method not implemented
    ...    Test objective: The objective is to test that DELETE  method is not allowed to delete a VNFD
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4.3.5 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send DELETE Request for VNFD in individual VNF Package
    Check HTTP Response Status Code Is    405
    
Get VNFD in Individual VNF Package with security information
    [Documentation]    Test ID: 5.3.5.3.12
    ...    Test title: Get VNFD in Individual VNF Package with security information
    ...    Test objective: The objective is to test the retrieval of the VNFD in zip format for an individual VNF package shall include in the ZIP archive the security information when requested with "include_signature" parameter, and perform a validation that returned content is in zip format
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 9.4.4.3.2 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get VNFD in Individual VNF Package with security information
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip
    
*** Keywords ***
Void
    log    do nothing
