*** Settings ***
Resource          NFVMANOPMKeywords.robot

*** Test Cases ***
POST Create new Performance Threshold
    [Documentation]    Test ID: 8.3.2.4.1
    ...    Test title:  POST Create new Performance Threshold
    ...    Test objective: The objective is to test the creation of a new NFV-MANO performance threshold and perform the JSON schema validation of the returned threshold data structure.
    ...    Pre-conditions: A NFV-MANO instance is instantiated.
    ...    Reference: clause 6.5.6.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The NFV-MANO Performance Threshold is successfully created on the NFV-MANO
    Send Post Request Create new Performance Threshold
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is   Threshold
    Check HTTP Response Header Contains    Location
    Check Postcondition Threshold Exists

GET All Performance Thresholds
    [Documentation]    Test ID: 8.3.2.4.2
    ...    Test title: GET All Performance Thresholds
    ...    Test objective: The objective is to test the retrieval of all the available NFV-MANO performance thresholds and perform a JSON schema validation of the collected thresholds data structure.
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance thresholds are set.
    ...    Reference: clause 6.5.6.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET all Performance Thresholds
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   Thresholds

GET Performance Thresholds with attribute-based filter
    [Documentation]    Test ID: 8.3.2.4.3
    ...    Test title: GET Performance Thresholds with attribute-based filter
    ...    Test objective: The objective is to test the retrieval of all the available NFV-MANO performance thresholds when using attribute-based filters, perform a JSON schema validation of the collected thresholds data structure, and verify that the retrieved information matches the issued attribute-based filter
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance thresholds are set in the NFV-MANO.
    ...    Reference: clause 6.5.6.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Performance Thresholds with attribute-based filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   Thresholds
    Check HTTP Response Body Thresholds match the requested attribute-based filter
    
GET Performance Threshold with Paged Response
    [Documentation]    Test ID: 8.3.2.4.4
    ...    Test title: GET Performance Threshold with Paged Response
    ...    Test objective: The objective is to query information about NFV-MANO Performance Thresholds to get Paged Response.
    ...    Pre-conditions:  A NFV-MANO instance is instantiated. One or more NFV-MANO performance thresholds are set.
    ...    Reference: clause 6.5.6.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET all Performance Thresholds
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains Link
    
GET Performance Thresholds - Invalid attribute-based filter
    [Documentation]    Test ID: 8.3.2.4.5
    ...    Test title: GET Performance Thresholds - Invalid attribute-based filter
    ...    Test objective: The objective is to test that the retrieval of NFV-MANO performance thresholds fails when using invalid attribute-based filter, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: A NFV-MANO instance is instantiated. One or more NFV-MANO performance thresholds are set.
    ...    Reference: clause 6.5.6.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Performance Thresholds with invalid attribute-based filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET Performance Threshold - Bad Request Response too Big
    [Documentation]    Test ID: 8.3.2.4.6
    ...    Test title: GET Performance Threshold - Bad Request Response too Big
    ...    Test objective: The objective is to test that the retrieval of NFV-MANO performance thresholds fails when response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions:  A NFV-MANO instance is instantiated. One or more NFV-MANO performance thresholds are set.
    ...    Reference: clause 6.5.6.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET all Performance Thresholds
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
PUT Performance Thresholds - Method not implemented
    [Documentation]    Test ID: 8.3.2.4.7
    ...    Test title: PUT Performance Thresholds - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to modify NFV-MANO Performance Thresholds
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.6.3.3 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request for all Performance Thresholds
    Check HTTP Response Status Code Is    405

PATCH Performance Thresholds - Method not implemented
    [Documentation]    Test ID: 8.3.2.4.8
    ...    Test title: PATCH Performance Thresholds - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to modify NFV-MANO Performance Thresholds
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.6.3.4 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for all Performance Thresholds
    Check HTTP Response Status Code Is    405

DELETE Performance Thresholds - Method not implemented
    [Documentation]    Test ID: 8.3.2.4.9
    ...    Test title: DELETE Performance Thresholds - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to update NFV-MANO Performance Thresholds
    ...    Pre-conditions: none
    ...    Reference: clause 6.5.6.3.5 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send DELETE Request for all Performance Thresholds
    Check HTTP Response Status Code Is    405

POST Create new Performance Threshold - Unprocessable entity
    [Documentation]    Test ID: 8.3.2.4.10
    ...    Test title:  POST Create new Performance Threshold - Unprocessable Entity
    ...    Test objective: The objective is to test the creation of a new NFV-MANO performance threshold and perform the JSON schema validation of the returned threshold data structure.
    ...    Test objective: The objective is to test that a new NFV-MANO performance threshold is not created if the notification endpoint is unreachable by the NFV-MANO.
    ...    Pre-conditions: A NFV-MANO instance is instantiated.
    ...    Reference: clause 6.5.6.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: Notification endpoint is unreachable by the NFV-MANO.
    ...    Post-Conditions: none
    Send Post Request Create new Performance Threshold with unreachable notification endpoint
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is   ProblemDetails
