*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Resource          NSDManagementKeywords.robot
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library           OperatingSystem

*** Test Cases ***
Get NSD Archive Manifest
    [Documentation]    Test ID: 5.3.1.12.1
    ...    Test title: Get NSD Archive Manifest
    ...    Test objective: The objective is to test that GET method reads the content of the manifest file within an NSD archive
    ...    Pre-conditions: One or more NSDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.4b.3.2 - ETSI GS NFV-SOL 005 [3] v4.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NSD Archive Manifest
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    text/plain
    
Get NSD Archive Manifest with security information
    [Documentation]    Test ID: 5.3.1.12.2
    ...    Test title: Get NSD Archive Manifest with security information
    ...    Test objective: The objective is to test the retrieval of content of the manifest file within an NSD archive shall include in the ZIP archive the security information when requested with "include_signature" parameter
    ...    Pre-conditions: One or more NSDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.4b.3.2 - ETSI GS NFV-SOL 005 [3] v4.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get NSD Archive Manifest with security information
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip
    
Get NSD Archive Manifest with conflict due to onboarding state
    [Documentation]    Test ID: 5.3.1.12.3
    ...    Test title: Get NSD Archive Manifest with conflict due to onboarding state
    ...    Test objective: The objective is to test that the retrieval of content of the manifest file within an NSD archive fails due to a conflict when the NSD is not in onboarding state ONBOARDED in the NFVO. The test also performs a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: The onboarding state of the NSD is different from ONBOARDED.
    ...    Reference: Clause 5.4.4b.3.2 - ETSI GS NFV-SOL 005 [3] v4.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get NSD Archive Manifest with conflict due to onboarding state
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails  
    
POST NSD Archive Manifest - Method not implemented
    [Documentation]    Test ID: 5.3.1.12.4
    ...    Test title: POST NSD Archive Manifest - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new Network Service Descriptor Archive Manifest
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.4b.3.1 - ETSI GS NFV-SOL 005 [3] v4.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send POST Request for NSD Archive Manifest
    Check HTTP Response Status Code Is    405
    
PUT NSD Archive Manifest - Method not implemented
    [Documentation]    Test ID: 5.3.1.12.5
    ...    Test title: PUT NSD Archive Manifest - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update Network Service Descriptor Archive Manifest
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.4b.3.3 - ETSI GS NFV-SOL 005 [3] v4.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request for NSD Archive Manifest
    Check HTTP Response Status Code Is    405

PATCH NSD Archive Manifest - Method not implemented
    [Documentation]    Test ID: 5.3.1.12.6
    ...    Test title: PATCH NSD Archive Manifest - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update Network Service Descriptor Archive Manifest
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.4b.3.4 - ETSI GS NFV-SOL 005 [3] v4.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for NSD Archive Manifest
    Check HTTP Response Status Code Is    405

DELETE NSD Archive Manifest - Method not implemented
    [Documentation]    Test ID: 5.3.1.12.7
    ...    Test title: DELETE NSD Archive Manifest - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to delete Network Service Descriptor Archive Manifest
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.4b.3.5 - ETSI GS NFV-SOL 005 [3] v4.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send DELETE Request for NSD Archive Manifest
    Check HTTP Response Status Code Is    405