/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;

final class MockServerEventBus {
    private static MockServerEventBus instance;
    private final Multimap<EventType, SubscriberHandler> subscribers = LinkedListMultimap.create();

    private MockServerEventBus() {
    }

    public static MockServerEventBus getInstance() {
        if (instance == null) {
            instance = new MockServerEventBus();
        }
        return instance;
    }

    void publish(EventType event) {
        for (SubscriberHandler subscriber : this.subscribers.get(event)) {
            subscriber.handle();
        }
    }

    public void subscribe(SubscriberHandler subscriber, EventType ... events) {
        for (EventType event : events) {
            this.subscribers.put(event, subscriber);
        }
    }

    static interface SubscriberHandler {
        public void handle();
    }

    static enum EventType {
        STOP,
        RESET;

    }
}

