/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithJsonToString;

public class KeyToMultiValue
extends ObjectWithJsonToString {
    private final NottableString name;
    private final List<NottableString> values;
    private int hashCode;

    public KeyToMultiValue(String name, String ... values) {
        this(NottableString.string(name), NottableString.strings(values));
    }

    public KeyToMultiValue(NottableString name, NottableString ... values) {
        this(name, Arrays.asList(values));
    }

    public KeyToMultiValue(String name, Collection<String> values) {
        this(NottableString.string(name), NottableString.strings(values));
    }

    public KeyToMultiValue(NottableString name, Collection<NottableString> values) {
        this.name = name;
        this.values = values == null || values.isEmpty() ? Collections.singletonList(NottableString.string(".*")) : new ArrayList<NottableString>(values);
        this.hashCode = Objects.hash(this.name, this.values);
    }

    public NottableString getName() {
        return this.name;
    }

    public List<NottableString> getValues() {
        return this.values;
    }

    public void addValue(String value) {
        this.addValue(NottableString.string(value));
    }

    public void addValue(NottableString value) {
        if (this.values != null && !this.values.contains(value)) {
            this.values.add(value);
        }
        this.hashCode = Objects.hash(this.name, this.values);
    }

    public void addValues(List<String> values) {
        this.addNottableValues(NottableString.deserializeNottableStrings(values));
    }

    public void addNottableValues(List<NottableString> values) {
        if (this.values != null) {
            for (NottableString value : values) {
                if (this.values.contains(value)) continue;
                this.values.add(value);
            }
        }
    }

    public void addValues(String ... values) {
        this.addValues(Arrays.asList(values));
    }

    public void addValues(NottableString ... values) {
        this.addNottableValues(Arrays.asList(values));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        KeyToMultiValue that = (KeyToMultiValue)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }
}

