/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.builder;

import java.beans.Introspector;
import java.lang.reflect.Method;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.xmlunit.builder.Input;

public class JaxbBuilder
implements Input.Builder {
    private final Object object;
    private Marshaller marshaller;
    private boolean userObjectFactory;

    protected JaxbBuilder(Object object) {
        this.object = object;
    }

    public JaxbBuilder withMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    public JaxbBuilder useObjectFactory() {
        this.userObjectFactory = true;
        return this;
    }

    @Override
    public Source build() {
        try {
            if (this.marshaller == null) {
                this.createDefaultMarshaller();
            }
            Object jaxbObject = this.getPreparedJaxbObject();
            JAXBSource jaxbSource = new JAXBSource(this.marshaller, jaxbObject);
            jaxbSource.setInputSource(null);
            return jaxbSource;
        }
        catch (JAXBException e) {
            throw new DataBindingException(e);
        }
    }

    private Object getPreparedJaxbObject() {
        Class<?> clazz;
        XmlRootElement r;
        Object jaxbObject = this.object instanceof JAXBElement ? this.object : ((r = (clazz = this.object.getClass()).getAnnotation(XmlRootElement.class)) == null ? (this.userObjectFactory ? JaxbBuilder.createJAXBElement(this.object) : JaxbBuilder.createInferredJAXBElement(this.object)) : this.object);
        return jaxbObject;
    }

    private void createDefaultMarshaller() throws JAXBException, PropertyException {
        JAXBContext context;
        if (this.object instanceof JAXBElement) {
            context = JAXBContext.newInstance(((JAXBElement)this.object).getDeclaredType());
        } else {
            Class<?> clazz = this.object.getClass();
            context = JAXBContext.newInstance(clazz);
        }
        this.marshaller = context.createMarshaller();
        this.marshaller.setProperty("jaxb.formatted.output", true);
    }

    private static <T> JAXBElement<T> createInferredJAXBElement(T object) {
        Class<?> clazz = object.getClass();
        return new JAXBElement(new QName(JaxbBuilder.inferName(clazz)), clazz, object);
    }

    private static <T> JAXBElement<T> createJAXBElement(T jaxbObj) {
        JAXBElement<T> jaxbElementFromObjectFactory = JaxbBuilder.createJaxbElementFromObjectFactory(jaxbObj);
        if (jaxbElementFromObjectFactory == null) {
            return JaxbBuilder.createInferredJAXBElement(jaxbObj);
        }
        return jaxbElementFromObjectFactory;
    }

    private static <T> JAXBElement<T> createJaxbElementFromObjectFactory(T obj) {
        try {
            Class<?> objFactClass = JaxbBuilder.getObjectFactoryClass(obj);
            Object objFact = objFactClass.newInstance();
            Method[] methods = objFactClass.getMethods();
            Object jaxbObj = null;
            for (Method method : methods) {
                Class<?>[] params = method.getParameterTypes();
                if (params.length != 1 || params[0] != obj.getClass() || !method.getReturnType().isAssignableFrom(JAXBElement.class)) continue;
                jaxbObj = method.invoke(objFact, obj);
                break;
            }
            return (JAXBElement)jaxbObj;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <T> Class<?> getObjectFactoryClass(T obj) throws ClassNotFoundException {
        String objFactClassName = obj.getClass().getPackage().getName() + ".ObjectFactory";
        return Thread.currentThread().getContextClassLoader().loadClass(objFactClassName);
    }

    private static String inferName(Class clazz) {
        return Introspector.decapitalize(clazz.getSimpleName());
    }
}

