*** Settings ***
Resource   environment/variables.txt 
Resource   NSInstanceUsageNotificationKeywords.robot  
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/

*** Test Cases ***
POST Individual Subscription - Method not implemented
    [Documentation]    Test ID: 9.3.4.2.1
    ...    Test title: POST Individual Subscription - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.4.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: The NS instance usage notification subscription is not created on the NFVO
    POST Individual Subscription
    Check HTTP Response Status Code Is    405

GET Information about an individual subscription
     [Documentation]    Test ID: 9.3.4.2.2
    ...    Test title: GET Information about an individual subscription
    ...    Test objective: The objective is to test the retrieval of NS instance usage notification subscription and perform a JSON schema validation of the returned subscription data structure
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.4.3.2 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual subscription
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   subscription

PUT an individual subscription - Method not implemented
     [Documentation]    Test ID: 9.3.4.2.3
    ...    Test title: PUT an individual subscription - Method not implemented
    ...    Test objective: TThe objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.4.3.3 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: The NS instance usage notification subscription is not modified by the operation
    PUT Individual Subscription
    Check HTTP Response Status Code Is    405

PATCH an individual subscription - Method not implemented
     [Documentation]    Test ID: 9.3.4.2.4
    ...    Test title: PATCH an individual subscription - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 8.5.4.3.4 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: The NS instance usage notification subscription is not modified by the operation
    PATCH Individual Subscription
    Check HTTP Response Status Code Is    405
    
DELETE an individual subscription
     [Documentation]    Test ID: 9.3.4.2.5
    ...    Test title: DELETE an individual subscription
    ...    Test objective: The objective is to test that DELETE method deletes an individual subscription
    ...    Pre-conditions: At least one instance usage notification subscription is available in the NFVO
    ...    Reference: Clause 8.5.4.3.5 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: The NS instance usage notification subscription is not available anymore on NFVO
    DELETE Individual Subscription
    Check HTTP Response Status Code Is    204