*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           OperatingSystem
Library           JSONLibrary
Resource          NFVMANOCimKeywords.robot
Library           MockServerLibrary
Library           Process
Suite Setup       Create Sessions
Suite Teardown    Terminate All Processes    kill=true

*** Test Cases ***
GET all Subscriptions
    [Documentation]    Test ID: 8.3.1.10.1
    ...    Test title: GET all Subscriptions
    ...    Test objective: The objective is to test the retrieval list of active subscriptions of API consumer and perform a JSON schema validation of the returned subscriptions data structure.
    ...    Pre-conditions:  At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.4.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none    
    Get all Subscriptions
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    CimSubscriptions

GET Subscriptions with attribute-based filter
    [Documentation]    Test ID:  8.3.1.10.2
    ...    Test title: GET Subscriptions with attribute-based filter
    ...    Test objective: The objective is to test the retrieval of active subscriptions list of API consumer using attribute-based filter and perform a JSON schema validation of the collected indicators data structure. 
    ...    Pre-conditions: At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.4.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Subscriptions with attribute-based filters
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    CimSubscriptions
    
GET Subscriptions with Paged Response
    [Documentation]    Test ID: 8.3.1.10.3
    ...    Test title: GET Subscriptions with Paged Response
    ...    Test objective: The objective is to query information of active subscriptions list to of API consumer to get Paged Response.
    ...    Pre-conditions:  At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.4.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: 
    ...    Post-Conditions: 
    Get all Subscriptions
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains Link
    
GET Subscriptions - invalid attribute-based filter
    [Documentation]    Test ID: 8.3.1.10.4
    ...    Test title: GET Subscriptions - invalid attribute-based filter
    ...    Test objective: The objective is to test that the retrieval of active subscriptions list of API consumer fails when using invalid attribute-based filters, and perform the JSON schema validation of the failed operation HTTP response. 
    ...    Pre-conditions: At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.4.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Subscriptions with invalid attribute-based filters
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails 


GET Subscriptions - Bad Request Response too Big
    [Documentation]    Test ID: 8.3.1.10.5
    ...    Test title: GET Subscriptions - Bad Request Response too Big
    ...    Test objective: The objective is to test that the retrieval of active subscriptions list of API consumer fails when response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.4.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get all Subscriptions
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET Subscriptions - invalid resource endpoint
    [Documentation]    Test ID: 8.3.1.10.6
    ...    Test title: GET Subscriptions - invalid resource endpoint
    ...    Test objective: The objective is to test that the retrieval of active subscriptions list of API consumer fails when using invalid resource endpoint.
    ...    Pre-conditions: At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.4.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none    
    Get all Subscriptions
    Check HTTP Response Status Code Is    404
    
POST Create new Subscription
    [Documentation]    Test ID: 8.3.1.10.7
    ...    Test title: Create new Subscription
    ...    Test objective: The objective is to test the creation of a new subscription and perform a JSON schema and content validation of the returned subscription data structure
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.4.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The subscription is successfully set and it matches the issued subscription    
    Send Post Request for Subscription
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is    CimSubscription
    Check HTTP Response Body CimSubscription Attributes Values Match the Issued Subscription
    Check Postcondition Subscription Is Set 


POST Create request for duplicated Subscription not creating duplicated subscriptions
    [Tags]    no-duplicated-subs
    [Documentation]    Test ID: 8.3.1.10.8
    ...    Test title: Create request for duplicated Subscription not creating duplicated subscriptions
    ...    Test objective: The objective is to test the attempt of a creation of a duplicated subscription failed and check that no new subscription is created and a link to the original subscription is returned
    ...    Pre-conditions: At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.4.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The NFV-MANO does not support the creation of duplicated subscriptions
    ...    Post-Conditions: The existing Subscription returned is available in the NFV-MANO 
    Send Post Request for Duplicated Subscription
    Check HTTP Response Status Code Is    303
    Check HTTP Response Body Is Empty
    Check HTTP Response Header Contains    Location
    Check Postcondition Subscription Resource Returned in Location Header Is Available

POST Create request for duplicated Subscription creating duplicated subscriptions
    [Tags]    duplicated-subs
    [Documentation]    Test ID: 8.3.1.10.9
    ...    Test title: Create request for duplicated Subscription creating duplicated subscriptions
    ...    Test objective: The objective is to test the creation of a duplicated subscription and perform a JSON schema and content validation of the returned duplicated subscription data structure
    ...    Pre-conditions: At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.4.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The NFV-MANO supports the creation of duplicated subscriptions
    ...    Post-Conditions: The duplicated subscription is successfully set and it matches the issued subscription
    Send Post Request for Duplicated Subscription
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is    PmSubscription
    Check HTTP Response Body CimSubscription Attributes Values Match the Issued Subscription
    Check Postcondition Subscription Is Set 

PUT Subscriptions - Method not implemented
    [Documentation]    Test ID: 8.3.1.10.10
    ...    Test title: PUT Subscriptions - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to modify subscriptions
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.4.3.3 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put Request for Subscriptions
    Check HTTP Response Status Code Is    405 
    
PATCH Subscriptions - Method not implemented
    [Documentation]    Test ID: 8.3.1.10.11
    ...    Test title: PATCH Subscriptions - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update subscriptions
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.4.3.4 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Patch Request for Subscriptions
    Check HTTP Response Status Code Is    405
    
DELETE Subscriptions - Method not implemented
    [Documentation]    Test ID: 8.3.1.10.12
    ...    Test title: DELETE Subscriptions - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to delete subscriptions
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.4.3.5 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none   
    Send Delete Request for Subscriptions
    Check HTTP Response Status Code Is    405

POST Create a new subscription - Unprocessable Entity
    [Documentation]    Test ID: 8.3.1.10.13
    ...    Test title: POST Create a new Subscription - Unprocessable Entity
    ...    Test objective: The objective is to test that a new subscription is not created if the notification endpoint is unreachable by the NFV-MANO.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.4.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: Notification endpoint is unreachable by the NFV-MANO
    ...    Post-Conditions: none 
    Send Post Request for Subscription with Unreachable callbackUri
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is  ProblemDetails
