*** Settings ***
Resource    FaultManagement-APIKeyword.robot

Suite Setup    Create Sessions
Suite Teardown    Terminate All Processes    kill=true

*** Test Cases ***
NFV-MANO Fault Alarm Notification
    [Documentation]    Test ID: 8.3.3.5.1
    ...    Test title: NFV-MANO Fault Alarm Notification
    ...    Test objective: The objective is to test the dispatch of NFV-MANO Fault Alarm Notification when a resource within an NFV-MANO instance fails, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A NFV-MANO instance is instantiated, and a subscription for fault alarm notifications is available.
    ...    Reference: clause 7.5.7.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger the fault of a virtualised resource in the NFV-MANO instance (external action) 
    Check Alarm Notification Http POST Request Body Json Schema Is    alarmNotification
    Check Alarm Notification Http POST Request Body notificationType attribute Is    alarmNotification

NFV-MANO Fault Alarm Cleared Notification
    [Documentation]    Test ID: 8.3.3.5.2
    ...    Test title: NFV-MANO Fault Alarm Cleared Notification
    ...    Test objective: The objective is to test the dispatch of NFV-MANO Fault Alarm Cleared Notification when a faulty resource within an NFV-MANO instance is cleared, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A NFV-MANO instance is instantiated, a virtualised resource is in faulty state, and a subscription for fault alarm cleared notifications is available.
    ...    Reference: clause 7.5.7.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger the clear of a faulty virtualised resource in the NFV-MANO instance (external action)
    Check Alarm cleared Notification Http POST Request Body Json Schema Is    alarmClearedNotification
    Check Alarm cleared Notification Http POST Request Body notificationType attribute Is    alarmClearedNotification

NFV-MANO Fault Alarm List Rebuilt Notification 
    [Documentation]    Test ID: 8.3.3.5.3
    ...    Test title: NFV-MANO Fault Alarm List Rebuilt Notification 
    ...    Test objective: The objective is to test the dispatch of NFV-MANO Fault Alarm List Rebuilt Notification when the NFV-MANO decides to rebuild the list of its NFV-MANO alarms, e.g. due to a corruption in the alarm storage, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A NFV-MANO instance is instantiated, one or more virtualised resource are in faulty state, and a subscription for fault alarm list rebuilt notifications is available.
    ...    Reference: clause 7.5.7.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger the NFV-MANO fault alarm list rebuild in the NFVO (external action) 
    Check Alarm list rebuilt Notification Http POST Request Body Json Schema Is    alarmListRebuiltNotification
    Check Alarm list rebuilt Notification Http POST Request Body notificationType attribute Is    alarmListRebuiltNotification
