*** Settings ***
Resource    environment/variables.txt 
Resource   NSLCMOperationKeywords.robot   
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    Process
Suite Setup    Create Sessions
Suite Teardown    Terminate All Processes    kill=true

*** Test Cases ***
NS Instance Deletion
    [Documentation]    Test ID: 5.3.2.19.1
    ...    Test title: NS Instance Deletion
    ...    Test objective: The objective is to test the workflow for Deleting a NS instance
    ...    Pre-conditions: the resource is in NOT_INSTANTIATED state
    ...    Reference: Clause 6.3.2 - ETSI GS NFV-SOL 005 [3] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: NS Instance resource is deleted
    DELETE IndividualNSInstance
    Check HTTP Response Status Code Is    204
    Check Notification Http POST Request Body Json Schema Is    NsIdentifierDeletionNotification
    Check Notification Http POST Request Body notificationType attribute Is    NsIdentifierDeletionNotification
    Check Postcondition NS instance is deleted

