*** Settings ***
Resource    environment/variables.txt
Resource    VNFLCMCoordinationKeywords.robot  
Library    String
Library    REST    ${EM-VNF_SCHEMA}://${EM-VNF_HOST}:${EM-VNF_PORT}    ssl_verify=false
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    OperatingSystem
Library    DependencyLibrary

*** Test Cases ***

POST Cancellation of an Ongoing Individual Coordination Action
    [Documentation]    Test ID: 6.3.6.4.1
    ...    Test title: POST Cancellation of an Ongoing Individual Coordination Action
    ...    Test Objective: The objective is to test that POST request for cancellation of an ongoing individual coordination Action has accepted for processing.
    ...    pre-condition: The status of the related LCM operation occurance is "PROCESSING"
    ...    Reference: Clause 10.4.4.3.1 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: When there is an Ongoing individual LCM operation coordination action.
    ...    Post-Condition: none
    POST Cancellation of an Ongoing Individual Coordination Action
    Check HTTP Response Status Code Is    202
    Check HTTP Response Body Should be Empty

POST Cancellation of an Ongoing Individual Coordination Action - Conflict
    [Documentation]    Test ID: 6.3.6.4.2
    ...    Test title: POST Cancellation of an Ongoing Individual Coordination Action - Conflict
    ...    Test Objective: The objective is to test that POST request for cancellation of an ongoing individual coordination Action is not successfull due to a conflict with the state of the "Individual coordination action" resource. 
    ...    pre-condition: none
    ...    Reference: Clause 10.4.4.3.1 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: Processing of Individual Coordination Action has 'Finished'.
    ...    Post-Condition: none
    POST Cancellation of an Ongoing Individual Coordination Action - Conflict
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails

Request a cancellation of an ongoing coordination action without authentication
    [Documentation]    Test ID: 6.3.6.4.3
    ...    Test title: Request a cancellation of an ongoing coordination action without authentication
    ...    Test objective: The objective is to test the failure of the request for a cancellation of a coordination task when no authentication is used
    ...    Pre-conditions: none
    ...    Reference: Clause Clause 10.4.4.3.1 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Cancellation of an Ongoing Individual Coordination Action without authorization token
    Check HTTP Response Status Code Is    401

GET Cancellation of an Ongoing Individual Coordination Action - Method not Implemented
    [Documentation]    Test ID: 6.3.6.4.4
    ...    Test title: GET Cancellation of an Ongoing Individual Coordination Action
    ...    Test Objective: The objective is to test that GET method for cancellation of an ongoing individual coordination Action is not implemented.
    ...    pre-condition: none
    ...    Reference: Clause 10.4.4.3.2 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: ongoing individual coordination
    ...    Post-Condition: none
    GET Cancellation of an Ongoing Individual Coordination Action
    Check HTTP Response Status Code Is    405

PUT Cancellation of an Ongoing Individual Coordination Action - Method not Implemented
    [Documentation]    Test ID: 6.3.6.4.5
    ...    Test title: PUT Cancellation of an Ongoing Individual Coordination Action
    ...    Test Objective: The objective is to test that PUT method for cancellation of an ongoing individual coordination Action is not implemented.
    ...    pre-condition: none
    ...    Reference: Clause 10.4.4.3.3 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none  
    ...    Post-Condition: none
    PUT Cancellation of an Ongoing Individual Coordination Action
    Check HTTP Response Status Code Is    405

PATCH Cancellation of an Ongoing Individual Coordination Action - Method not Implemented
    [Documentation]    Test ID: 6.3.6.4.6
    ...    Test title: PATCH Cancellation of an Ongoing Individual Coordination Action
    ...    Test Objective: The objective is to test that PATCH method for cancellation of an ongoing individual coordination Action is not implemented.
    ...    pre-condition: none
    ...    Reference: Clause 10.4.4.3.4 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none  
    ...    Post-Condition: none
    PATCH Cancellation of an Ongoing Individual Coordination Action
    Check HTTP Response Status Code Is    405

DELETE Cancellation of an Ongoing Individual Coordination Action - Method not Implemented
    [Documentation]    Test ID: 6.3.6.4.7
    ...    Test title: DELETE Cancellation of an Ongoing Individual Coordination Action
    ...    Test Objective: The objective is to test that DELETE method for cancellation of an ongoing individual coordination Action is not implemented.
    ...    pre-condition: none
    ...    Reference: Clause 10.4.4.3.5 - ETSI GS NFV-SOL 002 [2] v3.6.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none  
    ...    Post-Condition: none
    DELETE Cancellation of an Ongoing Individual Coordination Action
    Check HTTP Response Status Code Is    405