/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import com.google.common.util.concurrent.SettableFuture;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.HttpForwardActionResult;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public abstract class HttpForwardAction {
    protected final MockServerLogger mockServerLogger;
    private final NettyHttpClient httpClient;
    private HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();

    HttpForwardAction(MockServerLogger mockServerLogger, NettyHttpClient httpClient) {
        this.mockServerLogger = mockServerLogger;
        this.httpClient = httpClient;
    }

    protected HttpForwardActionResult sendRequest(HttpRequest httpRequest, @Nullable InetSocketAddress remoteAddress) {
        try {
            return new HttpForwardActionResult(httpRequest, this.httpClient.sendRequest(this.hopByHopHeaderFilter.onRequest(httpRequest), remoteAddress));
        }
        catch (Exception e) {
            this.mockServerLogger.error(httpRequest, (Throwable)e, "Exception forwarding request " + httpRequest, new Object[0]);
            return this.notFoundFuture(httpRequest);
        }
    }

    HttpForwardActionResult notFoundFuture(HttpRequest httpRequest) {
        SettableFuture<HttpResponse> notFoundFuture = SettableFuture.create();
        notFoundFuture.set(HttpResponse.notFoundResponse());
        return new HttpForwardActionResult(httpRequest, notFoundFuture);
    }
}

