*** Settings ***
Resource   environment/variables.txt 
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Variables    descriptors/SOL001/reference_tst010_vnf_b_2vdu_SOL001.yaml
Variables    descriptors/SOL006/reference_tst010_vnf_b_2vdu_SOL006.yaml
Documentation    This resource represents an individual grant. The client can use this resource to read the grant.
...    It is determined by means outside the scope of the present document, such as configuration or policy,
...    how long an individual grant is available.

*** Test Cases ***
POST Individual Grant - Method not implemented
    [Documentation]    Test ID: 7.3.2.2.1
    ...    Test title: POST Individual Grant - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed for Life cycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.4 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post individual Grant
    Check HTTP Response Status Code Is    405

GET an individual grant - Successful
    [Documentation]    Test ID: 7.3.2.2.2
    ...    Test title: GET an individual grant - Successful
    ...    Test objective: The objective is to retrieve a grant for a particular VNF Lifecycle Operation.
    ...    Pre-conditions: The  grant information is available to the VNFM
    ...    Reference: Clause 9.4.3.3.2 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get individual grant
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    grant
    Check HTTP Response Body grant content against VNF Descriptor
    
GET an individual grant - Process ongoing
    [Tags]    no-synchronous-mode
    [Documentation]    Test ID: 7.3.2.2.3
    ...    Test title: GET an individual grant - Process ongoing
    ...    Test objective: The objective is to retrieve a grant for a particular VNF lifecycle operation when process is ongoing and no grant is available yet.
    ...    Pre-conditions: The process of creating the grant is ongoing, no grant is available yet.
    ...    Reference: Clause 9.4.3.3.2 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get individual grant
    Check HTTP Response Status Code Is    202
    Check HTTP Response Body Json Schema Is    grant
    
GET an individual grant - grant rejected
    [Tags]    no-synchronous-mode
    [Documentation]    Test ID: 7.3.2.2.4
    ...    Test title: GET an individual grant - grant rejected
    ...    Test objective: The objective is to retrieve a grant for a particular VNF Lifecycle Operation but error returned because grant has been rejected.
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.3.3.2 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get individual grant
    Check HTTP Response Status Code Is    403
	Check HTTP Response Body Json Schema Is    ProblemDetails

PUT an individual grant - Method not implemented
    [Documentation]    Test ID: 7.3.2.2.5
    ...    Test title: PUT an individual grant - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to for Life cycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.3.3.3 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT individual Grant
    Check HTTP Response Status Code Is    405

PATCH an individual grant - Method not implemented
    [Documentation]    Test ID: 7.3.2.2.6
    ...    Test title: PATCH an individual grant - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to for Life cycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.3.3.4 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Patch individual Grant
    Check HTTP Response Status Code Is    405
    
DELETE an individual grant - Method not implemented
    [Documentation]    Test ID: 7.3.2.2.7
    ...    Test title: DELETE an individual grant - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to for Life cycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.3.3.5 - ETSI GS NFV-SOL 003 [1] v2.7.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Delete individual Grant
    Check HTTP Response Status Code Is    405

*** Keywords ***    
Get individual grant
    log    Trying to read an individual grant
    Set Headers    {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId} 
    Integer    response status    200
    
Post individual Grant
    log    Trying to read an individual grant
    Pass Execution If    ${SYNC_MODE} == 1   Skipping. Synchronous mode is supported    
    Set Headers    {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Put individual Grant
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Patch individual Grant
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Delete individual Grant
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    ${schema} =    Catenate    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    
Check HTTP Response Body grant content against VNF Descriptor
    Run Keyword If    ${check_descriptors} == 1    Check Individual grant Content
    
Check Individual grant Content    
    PARSE the Descriptor File
    Match the grant Response Attributes with Descriptors
    
PARSE the Descriptor File
    Run Keyword If  '${descriptorType}'=='SOL001'    Fetch Information from SOL001 descriptor file    ELSE    Fetch Information from SOL006 descriptor file
    
Fetch Information from SOL001 descriptor file
    @{VDU_labels}=    Create List
    @{VNF_labels}=    Create List
    @{VirtualLink_labels}=    Create List
    @{CP_labels}=    Create List
    @{Storage_labels}=    Create List
    FOR    ${key}    IN    @{topology_template.node_templates.keys()} 
        ${key_type}=    Get Variable Value    ${topology_template.node_templates.${key}.type}
        ${VDU_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}   ${tosca_type_VDU_compute}
        ${VNF_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_VNF}
        ${Link_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_virtual_link}
        ${VDUcp_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_VDU_cp}
        ${Storage_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_storage}
        Run Keyword If    ${VDU_check}    Append To List    ${VDU_labels}    ${key}
        Run Keyword If    ${VNF_check}    Append To List    ${VNF_labels}    ${key}
        Run Keyword If    ${VNF_check}    Get VNF Attributes from SOL001    ${key}            
        Run Keyword If    ${Link_check}    Append To List    ${VirtualLink_labels}    ${key}
        Run Keyword If    ${VDUcp_check}    Append To List    ${CP_labels}    ${key}
        Run Keyword If    ${Storage_check}    Append To List    ${Storage_labels}    ${key}
    END
    Set Global Variable    @{VDU_IDs}    @{VDU_labels}
    Set Global Variable    @{VNF_IDs}    @{VNF_labels}
    Set Global Variable    @{VirtualLink_IDs}    @{VirtualLink_labels}
    Set Global Variable    @{CP_IDs}    @{CP_labels}
    Set Global Variable    @{Storage_IDs}    @{Storage_labels}

Get VNF Attributes from SOL001
     [Arguments]    ${VNF_label}
    ${descriptor_id}=    Get Variable Value    ${topology_template.node_templates.${VNF_label}.properties.descriptor_id}
    ${provider}=    Get Variable Value    ${topology_template.node_templates.${VNF_label}.properties.provider}
    ${product_name}=    Get Variable Value    ${topology_template.node_templates.${VNF_label}.properties.product_name}
    ${software_version}=    Get Variable Value    ${topology_template.node_templates.${VNF_label}.properties.software_version}
    ${descriptor_version}=    Get Variable Value    ${topology_template.node_templates.${VNF_label}.properties.descriptor_version}
    ${flavour_id}=    Get Variable Value    ${topology_template.node_templates.${VNF_label}.properties.flavour_id}
    
    Set Global Variable    ${Descriptor_ID}    ${descriptor_id}
    Set Global Variable    ${Provider}    ${provider}
    Set Global Variable    ${Product_Name}    ${product_name}
    Set Global Variable    ${Software_Version}    ${software_version}
    Set Global Variable    ${Descriptor_Version}    ${descriptor_version}
    Set Global Variable    ${Flavour_ID}    ${flavour_id}
    
Fetch Information from SOL006 descriptor file
    ${descriptor_id}=    Get Variable Value    ${nfv.vnfd[0].id}
    ${provider}=    Get Variable Value    ${nfv.vnfd[0].provider}
    ${product_name}=    Get Variable Value    ${nfv.vnfd[0]['product-name']}
    ${software_version}=    Get Variable Value    ${nfv.vnfd[0]['software-version']}
    ${descriptor_version}=    Get Variable Value    ${nfv.vnfd[0].version}    
    ${VDUcount}=    Get Length    ${nfv.vnfd[0].vdu}
    ${extCP_count}=    Get Length    ${nfv.vnfd[0]['ext-cpd']}
    ${virtualLink_count}=    Get length    ${nfv.vnfd[0]['int-virtual-link-desc']}
    ${instantiation_levels}=    Get Length    ${nfv.vnfd[0].df['instantiation-level']}    
    FOR    ${key}    IN    @{nfv.vnfd[0].keys()}
        ${VDU_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    vdu
        Run Keyword If    ${VDU_check}    Get VDU IDs    ${VDUcount}
        ${extCP_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    ext-cpd
        Run Keyword If    ${extCP_check}    Get External CP IDs    ${extCP_count}
        ${virtualLink_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    int-virtual-link-desc
        Run Keyword If    ${virtualLink_check}    Get Virtual Link IDs   ${virtualLink_count}    
        ${DF_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    df
        Run Keyword If    ${DF_check}    Get Instantiation Levels    ${instantiation_levels}    
    END
    Set Global Variable    ${Descriptor_ID}    ${descriptor_id}
    Set Global Variable    ${Provider}    ${provider}
    Set Global Variable    ${Product_Name}    ${product_name}
    Set Global Variable    ${Software_Version}    ${software_version}
    Set Global Variable    ${Descriptor_Version}    ${descriptor_version}
    
Get VDU IDs
    [Arguments]    ${count}    
    @{VDU_labels}=    Create List
    ${Storage_labels}=    Create List
    ${Compute_labels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${VDU_labels}    ${nfv.vnfd[0].vdu[${i}]['id']}
        Append To List    ${Storage_labels}    ${nfv.vnfd[0].vdu[${i}]['virtual-storage-desc']}
        Append To List    ${Compute_labels}    ${nfv.vnfd[0].vdu[${i}]['virtual-compute-desc']} 
        Get Internal CPs for each VDU    ${i}   
    END
    Set Global Variable    ${VDU_IDs}    ${VDU_labels}
    Set Global Variable    ${Storage_IDs}    ${Storage_labels}
    Set Global Variable    ${Compute_IDs}    ${Compute_labels}
            
Get Internal CPs for each VDU
    [Arguments]    ${vdu}
    ${count}=    Get Length    ${nfv.vnfd[0].vdu[${vdu}]['int-cpd']}    
    ${internal_CPs}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${internal_CPs}    ${nfv.vnfd[0].vdu[${vdu}]['int-cpd'][${i}]['id']} 
    END
    Set Global Variable    ${internalCP_IDs}    ${internal_CPs}
    
Get External CP IDs
    [Arguments]    ${count}    
    @{external_CPs}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${external_CPs}    ${nfv.vnfd[0].ext_cpd[${i}].id} 
    END
    Set Global Variable    ${externalCP_IDs}    ${external_CPs}

Get Virtual Link IDs
    [Arguments]    ${count}    
    ${VirtualLink_labels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${VirtualLink_labels}    ${nfv.vnfd[0]['int-virtual-link-desc'][${i}]['id']} 
    END
    Set Global Variable    ${VirtualLink_IDs}    ${VirtualLink_labels}
    
Get Instantiation Levels
    [Arguments]    ${count}
    @{Instantiation_Levels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${Instantiation_Levels}    ${nfv.vnfd[0].df['instantiation-level'][${i}]['id']} 
    END
    Set Global Variable    ${InstantiationLevel_IDs}    ${Instantiation_Levels}
    
Match the grant Response Attributes with Descriptors
    Run Keyword If  '${descriptorType}'=='SOL006'    List Should Contain Value    ${externalCP_IDs}    ${response['body']['Grant']['extVirtualLinks']['extCps']['cpdId']}
    Run Keyword If  '${descriptorType}'=='SOL001'    List Should Contain Value    @{CP_IDs}    ${response['body']['Grant']['extVirtualLinks']['extCps']['cpdId']}
    List Should Contain Value    ${VirtualLink_IDs}    ${response['body']['Grant']['ExtManagedVirtualLinkData']['vnfVirtualLinkDescId']}
    List Should Contain value    ${Compute_IDs}    ${response['body']['Grant']['vimAssets']['computeResourceFlavours']['vnfdVirtualComputeDescId']}
    


    
