*** Settings ***
Resource    environment/variables.txt  
Library     REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}     ssl_verify=false
Library     DependencyLibrary
Library     JSONLibrary
Library     JSONSchemaLibrary    schemas/

*** Keywords ***
POST API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PUT API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PATCH API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PUT API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PATCH API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
	
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings   ${response['status']}    ${expected_status}
    Log    Status code validated 

Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Run Keyword If    '${input}' == 'ProblemDetails'    Should Contain    ${response['headers']['Content-Type']}    application/problem+json
    ...    ELSE    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK
    
POST VNF Snapshot Packages
    Log    Trying to perform a POST. This method should not be implemented.
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Set Headers    {"Content-Type":"${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        
	
GET multiple VNF Snapshot Packages	
    Log    Query VNF The GET method queries information about multiple VNF Snapshot Packages.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 		

GET multiple VNF Snapshot Packages with bad attribute	
    Log    Query VNF The GET method queries information about multiple VNF Snapshot Packages.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?attribute_not_exist=some_value
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

GET multiple VNF Snapshot Packages with bad filter	
    Log    Query VNF The GET method queries information about multiple VNF Snapshot Packages.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?${NEG_FILTER}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
	
GET multiple VNF Snapshot Packages using filter	
    Log    Query VNF The GET method queries information about multiple VNF Snapshot Packages.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?${POS_FILTER}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
	
GET multiple VNF Snapshot Packages with all_fields attribute selector
    Log    Query status information about multiple VNF Snapshot Packages, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?all_fields
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET multiple VNF Snapshot Packages with exclude_default attribute selector
    Log    Query status information about multiple VNF Snapshot Packages using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET multiple VNF Snapshot Packages with fields attribute selector
    Log    Query status information about multiple VNF Snapshot Packages, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}	    
    
GET multiple VNF Snapshot Packages with exclude_default and fields attribute selector
    Log    Query status information about multiple VNF Snapshot Packages, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?fields=${fields}&exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET multiple VNF Snapshot Packages with exclude_fields attribute selector
    Log    Query status information about multiple VNF Snapshot Packages, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages?exclude_fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 	

GET VNF Snapshot Packages without Paging support
    Run Keyword If    ${PAGING_SUPPORTED} == 0    GET multiple VNF Snapshot Packages
    
GET VNF Snapshot Packages with Paging support
    Run Keyword If    ${PAGING_SUPPORTED} == 1    GET multiple VNF Snapshot Packages

Check HTTP Response Header Contains Link
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}

PUT VNF Snapshot Packages
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages   	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH VNF Snapshot Packages
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE VNF Snapshot Packages
    Log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}   

POST individual VNF Snapshot Package
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}    
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

GET individual VNF Snapshot Package
    log    Trying to get information about an individual VNF Snapshot Package
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      

GET individual VNF Snapshot Package with invalid URI
    log    Trying to get information about an individual VNF Snapshot Package
    Set Headers    {"Accept":"${ACCEPT_JSON}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${invalidVnfSnapshotPkgId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      
	
PUT individual VNF Snapshot Package
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH individual VNF Snapshot Package
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE individual VNF Snapshot Package
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST VNF Snapshot Package Content
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_ZIP}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content   
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

GET VNF Snapshot Package Content - Complete
    log    Trying to fetch the complete contents of VNF Snapshot Package
    Set Headers    {"Accept":"${ACCEPT_ZIP}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

GET VNF Snapshot Package Content - Range Request
    Pass Execution If    ${NFVO_RANGE_OK} == 0    Skipping this test as NFVO is not able to handle partial Requests.
    log    Trying to get information about an individual VNF Snapshot Package using a range request
    Set Headers    {"Accept":"${ACCEPT_ZIP}"}  
    Set Headers    {"Range":"${range}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content 		
    Unset Headers  ["Range"]
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

GET VNF Snapshot Package Content - Invalid Range
    Pass Execution If    ${NFVO_RANGE_OK} == 0    Skipping this test as NFVO is not able to handle partial Requests.
    log    Trying to get information about an individual VNF Snapshot Package with invalid range
    Set Headers    {"Accept":"${ACCEPT_ZIP}"}  
    Set Headers    {"Range":"${erroneousRange}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content 		
    Unset Headers  ["Range"]
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
GET VNF Snapshot Package Content - Not Available 
    Log    Trying to fetch the contents of a VNF Snapshot Package which is not in AVAILABLE state
    Set Headers    {"Accept":"${ACCEPT_ZIP}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId_notInAvailableState}/package_content 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
Check HTTP Content-Type Header Is Set For Package Content
    Log    Check Content-Type HTTP Header
    Should Contain    ${response['headers']}    Content-Type
    Should Be Equal As Strings    ${response['headers']['Content-Type']}    ${CONTENT_TYPE_ZIP} 
    Log    Content type validated

Check HTTP Content-Range Header Is Set
    Log    Check Content-Range HTTP Header
    Should Contain    ${response['headers']}    Content-Range
    Should Be Equal As Strings    ${response['headers']['Content-Range']}    ${range}/${full_length}
    Log    Header Content-Range is present

Check HTTP Content-Length Header Is Set
    Log    Check Content-Length HTTP Header
    Should Contain    ${response['headers']}    Content-Length
    Should Be Equal As Strings    ${response['headers']['Content-Length']}    ${full_length}
    Log    Header Content-Length is present

PUT VNF Snapshot Package Content
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_ZIP}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_ZIP}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH VNF Snapshot Package Content
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_ZIP}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_ZIP}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE VNF Snapshot Package Content
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_ZIP}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/package_content 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

POST Individual VNF Snapshot Package Artifact
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_OCTET}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_OCTET}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath}   
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

GET Individual VNF Snapshot Package Artifact - Complete
    log    Trying to fetch the complete contents of an individual VNF Snapshot Package artifact
    Set Headers    {"Accept":"${ACCEPT_OCTET}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

GET Individual VNF Snapshot Package Artifact - Range Request
    Pass Execution If    ${NFVO_RANGE_OK} == 0    Skipping this test as NFVO is not able to handle partial Requests.
    log    Trying to get information about an individual VNF Snapshot Package artifact using a range request
    Set Headers    {"Accept":"${ACCEPT_OCTET}"}  
    Set Headers    {"Range":"${range}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath} 		
    Unset Headers  ["Range"]
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

GET Individual VNF Snapshot Package Artifact - Invalid Range
    Pass Execution If    ${NFVO_RANGE_OK} == 0    Skipping this test as NFVO is not able to handle partial Requests.
    log    Trying to get information about an individual VNF Snapshot Package artifact with invalid range
    Set Headers    {"Accept":"${CONTENT_TYPE_OCTET}"}  
    Set Headers    {"Range":"${erroneousRange}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath} 		
    Unset Headers  ["Range"]
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
GET Individual VNF Snapshot Package Artifact - Not Available 
    Log    Trying to get information about an individual artifact of a VNF Snapshot Package which is not in AVAILABLE state
    Set Headers    {"Accept":"${ACCEPT_OCTET}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId_notInAvailableState}/artifacts/${artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

PUT Individual VNF Snapshot Package Artifact
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_OCTET}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_OCTET}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH Individual VNF Snapshot Package Artifact
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_OCTET}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_OCTET}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE Individual VNF Snapshot Package Artifact
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT_OCTET}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshot_packages/${vnfSnapshotPkgId}/artifacts/${artifactPath} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

Check HTTP Content-Type Header Is Set For Package Artifact
    Log    Check Content-Type HTTP Header
    Should Contain    ${response['headers']}    Content-Type
    Should Be Equal As Strings    ${response['headers']['Content-Type']}    ${CONTENT_TYPE_OCTET} 
    Log    Content type validated

