*** Settings ***
Resource    VnfSnapshotPackageManagementKeywords.robot 

*** Test Cases ***
POST Upload VNF Snapshot Package Content from URI
    [Documentation]    Test ID: 5.3.6.5.1
    ...    Test title: POST Upload VNF Snapshot Package Content from URI
    ...    Test objective: The objective is to test that POST method provides the information for the NFVO to get the content of a VNF snapshot package.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.5.3.1 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Upload VNF Snapshot Package Content from URI
    Check HTTP Response Status Code Is    202 

POST Upload VNF Snapshot Package Content from URI - Conflict
    [Documentation]    Test ID: 5.3.6.5.2
    ...    Test title: POST Upload VNF Snapshot Package Content from URI - Conflict
    ...    Test objective: The objective is to test that a correct error code is returned when the POST method tries to intiate upload VNF Snapshot Package from URI task and the state of the VNF snapshot package resource is other than "CREATED" or "ERROR".
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.5.3.1 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The state of the VNF snapshot package resource is other than "CREATED" or "ERROR".
    ...    Post-Conditions: none
    POST Upload VNF Snapshot Package Content from URI - Conflict
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
GET Upload VNF Snapshot Package Content from URI - Method Not implemented
    [Documentation]    Test ID: 5.3.6.5.3
    ...    Test title: GET Upload VNF Snapshot Package Content from URI - Method Not implemented
    ...    Test objective: The objective is to test that GET method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.5.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Upload VNF Snapshot Package Content from URI
    Check HTTP Response Status Code Is    405

PUT Upload VNF Snapshot Package Content from URI - Method Not implemented
    [Documentation]    Test ID: 5.3.6.5.4
    ...    Test title: PUT Upload VNF Snapshot Package Content from URI - Method Not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.5.3.3 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Upload VNF Snapshot Package Content from URI
    Check HTTP Response Status Code Is    405
    
PATCH Upload VNF Snapshot Package Content from URI - Method Not implemented
    [Documentation]    Test ID: 5.3.6.5.5
    ...    Test title: PATCH Upload VNF Snapshot Package Content from URI - Method Not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.5.3.4 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Upload VNF Snapshot Package Content from URI
    Check HTTP Response Status Code Is    405

DELETE Upload VNF Snapshot Package Content from URI - Method Not implemented 
    [Documentation]    Test ID: 5.3.6.5.6
    ...    Test title: DELETE Upload VNF Snapshot Package Content from URI - Method Not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.5.3.5 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Upload VNF Snapshot Package Content from URI
    Check HTTP Response Status Code Is    405