*** Settings ***
Resource    VnfSnapshotPackageManagementKeywords.robot 

*** Test Cases ***
POST Access Configuration for External Artifacts - Method not implemented
    [Documentation]    Test ID: 5.3.6.9.1
    ...    Test title: POST Access Configuration for External Artifacts - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: Individual VNF Snapshot Package resource have been created.
    ...    Reference: Clause 11.4.9.3.1 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Access Configuration for External Artifacts
    Check HTTP Response Status Code Is    405
    
GET Access Configuration for External Artifacts
    [Documentation]    Test ID: 5.3.6.9.2
    ...    Test title: GET Access Configuration for External Artifacts
    ...    Test objective: The objective is to test that GET method reads the access configuration information that is used by the NFVO to get the content of external VNF snapshot package artifacts.
    ...    Pre-conditions: Individual VNF Snapshot Package resource have been created.
    ...    Reference: Clause 11.4.9.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Access Configuration for External Artifacts
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   VnfSnapshotPkgExtArtifactsAccessInfo
    
PUT Access Configuration for External Artifacts
    [Documentation]    Test ID: 5.3.6.9.3
    ...    Test title: PUT Access Configuration for External Artifacts
    ...    Test objective: The objective is to test that PUT method provides the access configuration information for the NFVO to download the content of external VNF package artifacts.
    ...    Pre-conditions: Individual VNF Snapshot Package resource have been created.
    ...    Reference: Clause 11.4.9.3.3 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Access Configuration for External Artifacts
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   VnfSnapshotPkgExtArtifactsAccessInfo

PUT Access Configuration for External Artifacts - Conflict
    [Documentation]    Test ID: 5.3.6.9.4
    ...    Test title: PUT Access Configuration for External Artifacts - Conflict
    ...    Test objective: The objective is to test that PUT method cannot provide the access configuration information to the NFVO when the VNF Snapshot Package resource is not in CREATED or ERROR state.
    ...    Pre-conditions: Individual VNF Snapshot Package resource have been created.
    ...    Reference: Clause 11.4.9.3.3 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The "state" attribute of the "Individual VNF snapshot package" resources contains a value different from "CREATED" or "ERROR".
    ...    Post-Conditions: none
    PUT Access Configuration for External Artifacts - Conflict
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
PATCH Access Configuration for External Artifacts - Method Not implemented
    [Documentation]    Test ID: 5.3.6.9.5
    ...    Test title: PATCH Access Configuration for External Artifacts - Method Not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.8.3.4 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Access Configuration for External Artifacts
    Check HTTP Response Status Code Is    405

DELETE Access Configuration for External Artifacts - Method Not implemented 
    [Documentation]    Test ID: 5.3.6.9.6
    ...    Test title: DELETE Access Configuration for External Artifacts - Method Not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.8.3.5 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Access Configuration for External Artifacts
    Check HTTP Response Status Code Is    405