*** Settings ***
Resource   environment/variables.txt
Library    REST     ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library    JSONLibrary
Library    Process
Library    JSONSchemaLibrary    schemas/
Library    OperatingSystem
Library    MockServerLibrary
Library    Collections
Library    String
#Variables  descriptors/SOL006/VNFD/vnfd_SOL006.yaml
#Variables  descriptors/SOL006/NSD/nsd_SOL006.yaml
#Variables  descriptors/SOL001/VNFD/vnfd_SOL001.yaml
#Variables  descriptors/SOL001/NSD/nsd_SOL001.yaml

*** Keywords ***
Initialize System
    Start Process  java  -jar  ../../bin/mockserver-netty-5.5.0-jar-with-dependencies.jar  -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}:${callback_port} 
    
Check Operation Occurrence Id
    Set Global Variable    @{nsLcmOpOccId}    ${response['headers']['Location']}
    Should Not Be Empty    ${nsLcmOpOccId}
    
Create Sessions
    Start Process  java  -jar  ../../bin/mockserver-netty-5.5.0-jar-with-dependencies.jar  -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}:${callback_port}   
    
Check subscription existence
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId} 
    Integer    response status    200
    
Check Instance Deleted
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}
    Integer    response status    404
    
Check Fail not supported
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}
    # how to check if Fail is not supported? Also In Sol002
    
Check Cancel not supported
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}
    # how to check if Cancel is not supported? Also In Sol002
    
Check Continue not supported
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}
    # how to check if Continue is not supported? Also In Sol002
    
Check retry not supported
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}
    # how to check if retry is not supported? Also In Sol002
    
Check Rollback not supported
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}
    # how to check if rollback is not supported? Also In Sol002
    
Check resource FAILED_TEMP
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId} 
    String    response body operationState    FAILED_TEMP

Check resource not 
    [Arguments]   ${status}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId} 
    Should Not Be Equal As Strings  response body operationState    ${status}

Check Operation Notification Status is
    [Arguments]    ${status}
    Check Operation Notification    NsLcmOperationOccurrenceNotification   ${status}

Check Operation Notification
    [Arguments]    ${element}    ${status}=""
    ${json}=	Get File	schemas/${element}.schema.json
    Configure Notification Forward    ${element}    ${callback_endpoint}    ${callback_endpoint_fwd}
    Configure Notification Status Handler    ${callback_endpoint_fwd}    ${status}
    ${BODY}=    evaluate    json.dumps(${json})    json
    &{notification_request}=  Create Mock Request Matcher	POST  ${callback_endpoint}  body_type="JSON"    body=${BODY}
    Wait Until Keyword Succeeds    2 min   10 sec   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}
    
Configure Notification Forward
    [Arguments]    ${element}    ${endpoint}    ${endpoint_fwd}    
   # ${BODY}=	evaluate	json.loads('''${json}''')	json
    Log  Creating mock HTTP forward to handle ${element}
    &{notification_tmp}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON_SCHEMA"    body=${element}
    &{notification_fwd}=  Create Mock Http Forward	${endpoint_fwd}
    Create Mock Expectation With Http Forward  ${notification_tmp}  ${notification_fwd}
    
Configure Notification Status Handler
    [Arguments]    ${endpoint}    ${status}=""
    ${json}=    evaluate    {"notificationStatus": {}}
    Run Keyword If   '${status}' != ""  set to dictionary    ${json["notificationStatus"]}    dp=${status}    
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle ${endpoint}
    &{req}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON"    body=${BODY}
    Set Global Variable    ${notification_request}    ${req}
    &{headers} =	Create Dictionary	"Content-Type"="application/json"
    &{notification_response}=  Create Mock Response	headers=${headers}  status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}    
        
Check resource operationState is
    [Arguments]    ${state} 
    String    ${response['body']['operationState']}   ${state}

Check resource Instantiated
    Wait Until Keyword Succeeds    2 min   10 sec   Probe resource Instantiated

Probe resource Instantiated 
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId} 
    String    response body nsState    INSTANTIATED

Check resource not_instantiated
    Wait Until Keyword Succeeds    2 min   10 sec   Probe resource not_instantiated

Probe resource not_instantiated
    [Arguments]  ${fresh_resource}=0
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log     ${fresh_resource}
    ${instanceId}=  Set Variable If	    ${fresh_resource} == 0   ${nsInstanceId}   ${response['body']['id']}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${instanceId}
    String    response body nsState     NOT_INSTANTIATED

Check operation resource state is FAILED_TEMP    
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId} 
    String    response body instantiationState    FAILED_TEMP 
    
Check operation resource state is not FAILED_TEMP
    Check operation resource state is FAILED_TEMP    
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId} 
    String  response body instantiationState  not  FAILED_TEMP

Check resource is finally failed
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId} 
    String    response body instantiationState    FINALLY_FAILED 

Launch another LCM operation
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/scaleNsToLevelRequest.json
    ${body}=        Format String   ${template}     instantiationLevelId=${instantiationLevelId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/scale_to_level    ${body}
    Integer    response status    202

Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId} 
    Integer    response status    200
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    Log    Validate Status code    
    Should Be Equal as Strings  ${response['status']}    ${expected_status}
    Log    Status code validated 
    
Check Postcondition NS Instance is deleted
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${disabledNsdId} 
    Integer    response status    404
    
Check HTTP Response Header Contains
    [Arguments]    ${HEADER_TOCHECK}
    Should Contain     ${response['headers']}    ${HEADER_TOCHECK}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Run Keyword If    '${input}' == 'ProblemDetails'    Should Contain    ${response['headers']['Content-Type']}    application/problem+json
    ...    ELSE    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK
    
Check Postcondition NS Instance is not deleted
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId} 
    Integer    response status    200
    
Check HTTP Response Header ContentType is
    [Arguments]    ${expected_contentType}
    Log    Validate content type
    Should Be Equal as Strings   ${response['headers']['Content-Type']}    ${expected_contentType}
    Log    Content Type validated 

POST New nsInstance
    Log    Create NS instance by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the NS Descriptor File
    ${template}=    Get File    jsons/CreateNsRequest.json 
    ${body}=        Format String   ${template}     nsdId=${NS_DescriptorID}   nsInstanceName=${nsInstanceName}   vimAccountId=${vimAccountId}   nsInstanceDescription=${nsInstanceDescription}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}     

Check HTTP Response Body NsInstance content against VNF Descriptor
    #${check_descriptors} flag, 1 to check descriptors
    Run Keyword If    ${check_descriptors} == 1    Check Individual NsInstance Content

Check Individual NsInstance Content    
    PARSE the Descriptor File
    Match the Response Attributes with Descriptors
    
PARSE the Descriptor File
    Run Keyword If  '${descriptorType}'=='SOL001'    Fetch Information from SOL001 descriptor file    ELSE    Fetch Information from SOL006 descriptor file
    
Fetch Information from SOL001 descriptor file
    Import Variables  ${CURDIR}/descriptors/SOL001/VNFD/vnfd_SOL001.yaml
    @{VDU_labels}=    Create List
    @{VNF_labels}=    Create List
    @{VirtualLink_labels}=    Create List
    @{CP_labels}=    Create List
    @{Storage_labels}=    Create List

    FOR    ${key}    IN    @{node_types.keys()}
        ${node_type}=    Get Variable Value    ${node_types['${key}']['derived_from']}
        ${is_VNF}=    Run Keyword And Return Status    Should Be Equal As Strings    ${node_type}    ${tosca_type_VNF}
        Run Keyword If    ${is_VNF}    Set Global Variable    ${tosca_type_derived_from_VNF}    ${key}
    END  
    ${derived_type_is_used}=    Run Keyword And Return Status    Should not be empty    ${tosca_type_derived_from_VNF}
    Run Keyword If    ${derived_type_is_used}    Set Global Variable    ${tosca_type_VNF}    ${tosca_type_derived_from_VNF}

    FOR    ${key}    IN    @{topology_template.node_templates.keys()} 
        ${key_type}=    Get Variable Value    ${topology_template.node_templates['${key}'].type}
        ${VDU_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}   ${tosca_type_VDU_compute}
        ${VNF_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_VNF}
        ${Link_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_virtual_link}
        ${VDUcp_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_VDU_cp}
        ${Storage_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_storage}
        Run Keyword If    ${VDU_check}    Append To List    ${VDU_labels}    ${key}
        Run Keyword If    ${VNF_check}    Append To List    ${VNF_labels}    ${key}
        Run Keyword If    ${VNF_check}    Get VNF Attributes from SOL001    ${key}            
        Run Keyword If    ${Link_check}    Append To List    ${VirtualLink_labels}    ${key}
        Run Keyword If    ${VDUcp_check}    Append To List    ${CP_labels}    ${key}
        Run Keyword If    ${Storage_check}    Append To List    ${Storage_labels}    ${key}
    END
    Set Global Variable    @{VDU_IDs}    @{VDU_labels}
    Set Global Variable    @{VNF_IDs}    @{VNF_labels}
    Set Global Variable    @{VirtualLink_IDs}    @{VirtualLink_labels}
    Set Global Variable    @{CP_IDs}    @{CP_labels}
    Set Global Variable    @{Storage_IDs}    @{Storage_labels}

Get VNF Attributes from SOL001
    [Arguments]    ${VNF_label}
    Import Variables  ${CURDIR}/descriptors/SOL001/VNFD/vnfd_SOL001.yaml
    ${descriptor_id}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.descriptor_id}
    ${provider}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.provider}
    ${product_name}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.product_name}
    ${software_version}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.software_version}
    ${descriptor_version}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.descriptor_version}
    ${flavour_id}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.flavour_id}
    
    Set Global Variable    ${Descriptor_ID}    ${descriptor_id}
    Set Global Variable    ${Provider}    ${provider}
    Set Global Variable    ${Product_Name}    ${product_name}
    Set Global Variable    ${Software_Version}    ${software_version}
    Set Global Variable    ${Descriptor_Version}    ${descriptor_version}
    Set Global Variable    ${Flavour_ID}    ${flavour_id}

Fetch Information from SOL006 descriptor file
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    ${descriptor_id}=    Get Variable Value    ${nfv.vnfd[0].id}
    ${provider}=    Get Variable Value    ${nfv.vnfd[0].provider}
    ${product_name}=    Get Variable Value    ${nfv.vnfd[0]['product-name']}
    ${software_version}=    Get Variable Value    ${nfv.vnfd[0]['software-version']}
    ${descriptor_version}=    Get Variable Value    ${nfv.vnfd[0].version}    
    ${VDUcount}=    Get Length    ${nfv.vnfd[0].vdu}
    ${extCP_count}=    Get Length    ${nfv.vnfd[0]['ext-cpd']}
    ${virtualLink_count}=    Get length    ${nfv.vnfd[0]['int-virtual-link-desc']}
    ${instantiation_levels}=    Get Length    ${nfv.vnfd[0].df['instantiation-level']}    
    FOR    ${key}    IN    @{nfv.vnfd[0].keys()}
        ${VDU_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    vdu
        Run Keyword If    ${VDU_check}    Get VDU IDs    ${VDUcount}
        ${extCP_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    ext-cpd
        Run Keyword If    ${extCP_check}    Get External CP IDs    ${extCP_count}
        ${virtualLink_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    int-virtual-link-desc
        Run Keyword If    ${virtualLink_check}    Get Virtual Link IDs   ${virtualLink_count}    
        ${DF_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    df
        Run Keyword If    ${DF_check}    Get Instantiation Levels    ${instantiation_levels}    
    END
    Set Global Variable    ${Descriptor_ID}    ${descriptor_id}
    Set Global Variable    ${Provider}    ${provider}
    Set Global Variable    ${Product_Name}    ${product_name}
    Set Global Variable    ${Software_Version}    ${software_version}
    Set Global Variable    ${Descriptor_Version}    ${descriptor_version}

Get VDU IDs
    [Arguments]    ${count}    
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    @{VDU_labels}=    Create List
    ${Storage_labels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${VDU_labels}    ${nfv.vnfd[0].vdu[${i}]['id']}
        Append To List    ${Storage_labels}    ${nfv.vnfd[0].vdu[${i}]['virtual-storage-desc']} 
        Get Internal CPs for each VDU    ${i}   
    END
    Set Global Variable    ${VDU_IDs}    ${VDU_labels}
    Set Global Variable    ${Storage_IDs}    ${Storage_labels}
            
Get Internal CPs for each VDU
    [Arguments]    ${vdu}
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    ${count}=    Get Length    ${nfv.vnfd[0].vdu[${vdu}]['int-cpd']}    
    ${internal_CPs}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${internal_CPs}    ${nfv.vnfd[0].vdu[${vdu}]['int-cpd'][${i}]['id']} 
    END
    Set Global Variable    ${internalCP_IDs}    ${internal_CPs}
    
Get External CP IDs
    [Arguments]    ${count}    
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    @{external_CPs}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${external_CPs}    ${nfv.vnfd[0]['ext-cpd'][${i}]['id']} 
    END
    Set Global Variable    ${externalCP_IDs}    ${external_CPs}

Get Virtual Link IDs
    [Arguments]    ${count}    
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    @{VirtualLink_labels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${VirtualLink_labels}    ${nfv.vnfd[0]['int-virtual-link-desc'][${i}]['id']} 
    END
    Set Global Variable    ${VirtualLink_IDs}    ${VirtualLink_labels}

Get Instantiation Levels
    [Arguments]    ${count}
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    @{Instantiation_Levels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${Instantiation_Levels}    ${nfv.vnfd[0].df['instantiation-level'][${i}]['id']} 
    END
    Set Global Variable    ${InstantiationLevel_IDs}    ${Instantiation_Levels}

Match the Response Attributes with Descriptors
    #Checking Response attributes with VNF Descriptors
    Should Be Equal As Strings    ${response['body']['vnfInstance'][0]['vnfdId']}    ${Descriptor_ID}
    Should Be Equal As Strings    ${response['body']['vnfInstance'][0]['vnfProvider']}    ${Provider}
    Should Be Equal As Strings    ${response['body']['vnfInstance'][0]['vnfProductName']}    ${Product_Name}
    Should Be Equal As Strings    ${response['body']['vnfInstance'][0]['vnfSoftwareVersion']}    ${Software_Version}
    Should Be Equal As Strings    ${response['body']['vnfInstance'][0]['vnfdVersion']}    ${Descriptor_Version}
    Should Be Equal As Strings    ${response['body']['vnfInstance'][0]['instantiatedVnfInfo']['flavourId']}    ${Flavour_ID}
    List Should Contain Value    ${VDU_IDs}    ${response['body']['vnfInstance'][0]['instantiatedVnfInfo']['vnfcResourceInfo']['vduId']}        
    Run Keyword If  '${descriptorType}'=='SOL006'    List Should Contain Value    ${externalCP_IDs}    ${response['body']['vnfInstance'][0]['instantiatedVnfInfo']['extCpInfo'][0]['cpdId']}
    Run Keyword If  '${descriptorType}'=='SOL006'    List Should Contain Value    ${internalCP_IDs}    ${response['body']['vnfInstance'][0]['instantiatedVnfInfo']['extCpInfo'][0]['cpdId']}
    Run Keyword If  '${descriptorType}'=='SOL001'    List Should Contain Value    ${CP_IDs}    ${response['body']['vnfInstance'][0]['instantiatedVnfInfo']['extCpInfo'][0]['cpdId']}
    List Should Contain value    ${Storage_IDs}    ${response['body']['vnfInstance'][0]['instantiatedVnfInfo']['virtualStorageResourceInfo'][0]['virtualStorageDescId']}
    List Should Contain Value    ${VirtualLink_IDs}    ${response['body']['vnfInstance'][0]['instantiatedVnfInfo']['extManagedVirtualLinkInfo'][0]['vnfVirtualLinkDescId']}

POST New nsInstance with DISABLED nsd
    Log    Create NS instance by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/CreateNsRequest.json 
    ${body}=        Format String   ${template}     nsdId=${disabledNsdId}   nsInstanceName=${nsInstanceName}   vimAccountId=${vimAccountId}   nsInstanceDescription=${nsInstanceDescription}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

GET NsInstances
    Log    Query NS The GET method queries information about multiple NS instances.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET NsInstances using filtering parameter
    Log    Query NS The GET method queries information about multiple NS instances.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get   ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances?${POS_filter_nsInstances}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

GET NsInstance Invalid Attribute-Based filtering parameter
    Log    Query NS The GET method queries information about multiple NS instances.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get   ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances?${NEG_filter_nsInstances}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET NsInstance Invalid Attribute Selector
    Log    Query NS The GET method queries information about multiple NS instances.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances?fields=wrong_field	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
Get NSInstances with all_fields attribute selector
    Log    Get the list of NSInstances, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances?all_fields
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
Get NSInstances with exclude_default attribute selector
    Log    Get the list of NSInstances, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
Get NSInstances with fields attribute selector
    Log    Get the list of NSInstances, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances?fields=${fields_nsInstances}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
Get NSInstances with fields and exclude_default attribute selector
    Log    Get the list of NSInstances, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances?fields=${fields_nsInstances}&exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}	
Get NSInstances with exclude_fields attribute selector
    Log    Get the list of NSInstances, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances?exclude_fields=${fields_nsInstances}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 
    	
PUT NSInstances
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}   
	
PATCH NSInstances
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
DELETE NSInstances
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

POST IndividualNSInstance
    Log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nonExistentNsId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET IndividualNSInstance
    Log    Trying to get information about an individual NS instance
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}
    ${Etag}=    Output    response headers ETag
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

    
PUT IndividualNSInstance
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
	
PATCH IndividualNSInstance
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
	
DELETE IndividualNSInstance
    log    Trying to delete an individual VNF instance
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
	

DELETE IndividualNSInstance Conflict
    log    Trying to delete an individual VNF instance
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${ConflictNsInstanceId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	


DELETE Instantiate NSInstance
    log    Trying to delete an instantiate NS instance. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/instantiate
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
 
 PATCH Instantiate NSInstance
    log    Trying to patch an instantiate NS instance. This method should not be implemented 
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/instantiate
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
 
PUT Instantiate NSInstance
    log    Trying to put an instantiate NS instance. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/instantiate
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET Instantiate NSInstance
    log    Trying to get an instantiate NS instance. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/instantiate
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
 POST Instantiate nsInstance
    Log    Trying to Instantiate a ns Instance
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the NS Descriptor File
    ${template}=    Get File    jsons/InstantiateNs.json
    ${body}=        Format String   ${template}     nsFlavourId=${nsFlavourId}   vimAccountId=${vimAccountId}   nsdId=${nsdId}    sapdId=${SAP_IDs[0]}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/instantiate    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Scale NSInstance
    log    Trying to delete an Scale NS instance. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/scale
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
 
 PATCH Scale NSInstance
    log    Trying to patch an Scale NS instance. This method should not be implemented 
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/scale
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
 
PUT Scale NSInstance
    log    Trying to put an Scale NS instance. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/scale
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET Scale NSInstance
    log    Trying to get an Scale NS instance. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/scale
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST scale nsInstance
	Log    Trying to Instantiate a scale NS Instance
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    ${template}=    Get File    jsons/ScaleNs.json
    ${body}=        Format String   ${template}     scaleType=${scaleType}   scaleTimeout=${scaleTimeout}   scaleVnfType=${scaleVnfType}   scaleGroupDescriptor=${scaleGroupDescriptor}   scaleMemberVnfIndex=${scaleMemberVnfIndex}    vnfInstantiationLevelId=${InstantiationLevel_IDs[0]}
	Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/scale    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE Update NSInstance
    log    Trying to delete an Update NS instance. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/update
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
 
 PATCH Update NSInstance
    log    Trying to patch an Update NS instance. This method should not be implemented 
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/update
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
 
PUT Update NSInstance
    log    Trying to put an Update NS instance. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/update
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET Update NSInstance
    log    Trying to get an Update NS instance. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/update
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST Update NSInstance
	Log    Trying to Instantiate a Update NS Instance
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    Run Keyword If    ${check_descriptors} == 1    PARSE the NS Descriptor File  
    ${template} =    Get File    jsons/UpdateNsRequest.json
    ${body}=        Format String   ${template}     vnfdId=${descriptor_id}    vnfFlavourId=${Flavour_ID}    newFlavourId=${Flavour_ID}    vnfVirtualLinkDescId=${VirtualLink_IDs[0]}    instantiationLevelId=${InstantiationLevel_IDs[1]}    vnfInstantiationLevelId=${InstantiationLevel_IDs[0]}    newNsdId=${NS_DescriptorID}    sapdId=${SAP_IDs[0]}    vnfInstanceId=${vnfInstanceId}    
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/update    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
 
DELETE Heal NSInstance
    log    Trying to Delete an Heal NS instance. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/heal
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
 
 PATCH Heal NSInstance
    log    Trying to patch an Heal NS instance. This method should not be implemented 
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/heal
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
 
PUT Heal NSInstance
    log    Trying to put an Heal NS instance. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/heal
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET Heal NSInstance
    log    Trying to get an Heal NS instance. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/heal
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST Heal NSInstance
	Log    Trying to Instantiate a Heal NS Instance
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/HealNsRequest.json
    ${body}=        Format String   ${template}     nsDegreeHealing=${nsDegreeHealing}
	Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/heal    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE Terminate NSInstance
    log    Trying to Delete an Terminate NS instance. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/terminate
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
 
PATCH Terminate NSInstance
    log    Trying to patch an Terminate NS instance. This method should not be implemented 
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/terminate
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
 
PUT Terminate NSInstance
    log    Trying to put an Terminate NS instance. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/terminate
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET Terminate NSInstance
    log    Trying to Get an Terminate NS instance. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/terminate
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST Terminate NSInstance
	Log    Trying to Instantiate a Terminate NS Instance
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/TerminateNsRequest.json
	Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_instances/${nsInstanceId}/terminate    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
		
POST NS LCM OP Occurrences
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PUT NS LCM OP Occurrences
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH NS LCM OP Occurrences
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE NS LCM OP Occurrences
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET NS LCM OP Occurrences
    Log    Query status information about multiple NS lifecycle management operation occurrences.
	Set Headers  {"Accept":"${ACCEPT}"}  
	Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
	Log    Execute Query and validate response
	Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
 
GET NS LCM OP Occurrences Invalid attribute-based filtering parameters
    Log    Query status information about multiple NS lifecycle management operation occurrences.
	Set Headers  {"Accept":"${ACCEPT}"}  
	Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
	GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs?${NEG_filter_nsLcmOpOcc}
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

GET NS LCM OP Occurrences using filtering parameters
    Log    Query status information about multiple NS lifecycle management operation occurrences.
	Set Headers  {"Accept":"${ACCEPT}"}  
	Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
	GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs?${POS_filter_nsLcmOpOcc}
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET NS LCM OP Occurrences Invalid attribute selector
    Log    Query status information about multiple NS lifecycle management operation occurrences.
    Set Headers  {"Accept":"${ACCEPT}"}  
	Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
	GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs?${NEG_SELECTOR}
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Get NS LCM OP Occurrences with all_fields attribute selector
    Log    Query status information about multiple NS lifecycle management operation occurrences, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs?all_fields
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
Get NS LCM OP Occurrences with exclude_default attribute selector
    Log    Query status information about multiple NS lifecycle management operation occurrences using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
Get NS LCM OP Occurrences with fields attribute selector
    Log    Query status information about multiple NS lifecycle management operation occurrences, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs?fields=${fields_nsLcmOpOcc}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
Get NS LCM OP Occurrences with fields and exclude_default attribute selector
    Log    Query status information about multiple NS lifecycle management operation occurrences, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs?fields=${fields_nsLcmOpOcc}&exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}	
Get NS LCM OP Occurrences with exclude_fields attribute selector
    Log    Query status information about multiple NS lifecycle management operation occurrences, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs?exclude_fields=${fields_nsLcmOpOcc}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 
    
POST Individual NS LCM OP Occurrence
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId} 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PUT Individual NS LCM OP Occurrence
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH Individual NS LCM OP Occurrence
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId} 	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Individual NS LCM OP Occurrence
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId} 	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET Individual NS LCM OP Occurrence
    Log    Query status information about individual NS lifecycle management operation occurrence.
	Set Headers  {"Accept":"${ACCEPT}"}  
	Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
	Log    Execute Query and validate response
	Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId} 
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
	
GET Retry operation task
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/retry 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PUT Retry operation task
    log    Trying to perform a PUT. This method should not be implemented 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/retry  		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH Retry operation task
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/retry  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Retry operation task
    log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/retry  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
POST Retry operation task
    Log    Retry a NS lifecycle operation if that operation has experienced a temporary failure
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/retry
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET Rollback operation task
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/rollback 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PUT Rollback operation task
    log    Trying to perform a PUT. This method should not be implemented 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/rollback  		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH Rollback operation task
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/rollback  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Rollback operation task
    log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/rollback  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
POST Rollback operation task
    Log    Rollback a NS lifecycle operation task
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/rollback
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET Continue operation task
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/continue 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PUT Continue operation task
    log    Trying to perform a PUT. This method should not be implemented 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/continue  		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH Continue operation task
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/continue  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Continue operation task
    log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/continue  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
POST Continue operation task
    Log    Continue a NS lifecycle operation task
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/continue
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

GET Fail operation task
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/fail 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PUT Fail operation task
    log    Trying to perform a PUT. This method should not be implemented 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/fail  		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH Fail operation task
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/fail  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Fail operation task
    log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/fail  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
POST Fail operation task
    Log    Fail a NS lifecycle operation task
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/fail
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET Cancel operation task
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/cancel 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PUT Cancel operation task
    log    Trying to perform a PUT. This method should not be implemented 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/cancel  		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH Cancel operation task
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/cancel  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Cancel operation task
    Log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/cancel  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
POST Cancel operation task
    Log    Cancel a NS lifecycle operation task
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/ns_lcm_op_occs/${nsLcmOpOccId}/cancel
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PUT subscriptions
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH subscriptions
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE subscriptions
    Log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
POST subscriptions
    Log    Create subscription instance by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the NS Descriptor File
    ${template}=    Get File    jsons/LccnSubscriptionRequest.json
    ${body}=        Format String   ${template}     callbackUri=${callback_uri}   callbackEndpoint=${callback_endpoint}   callbackPort=${callback_port}   nsdId=${NS_DescriptorID}
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	Clear Requests    ${callback_endpoint}
		
POST subscriptions DUPLICATION
    Log    Trying to create a subscription with an already created content
    Pass Execution If    ${NFVO_DUPLICATION} == 0    NFVO is not permitting duplication. Skipping the test
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the NS Descriptor File
    ${template}=    Get File    jsons/LccnSubscriptionRequest.json
    ${body}=        Format String   ${template}     callbackUri=${callback_uri}   callbackEndpoint=${callback_endpoint}   callbackPort=${callback_port}     nsdId=${NS_DescriptorID}
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	Clear Requests    ${callback_endpoint}
	
POST subscriptions NO DUPLICATION
    Log    Trying to create a subscription with an already created content
    Pass Execution If    ${NFVO_DUPLICATION} == 1    NFVO is permitting duplication.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the NS Descriptor File
    ${template}=    Get File    jsons/LccnSubscriptionRequest.json
    ${body}=        Format String   ${template}     callbackUri=${callback_uri}   callbackEndpoint=${callback_endpoint}   callbackPort=${callback_port}     nsdId=${NS_DescriptorID}
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}    
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	Clear Requests    ${callback_endpoint}

GET Subscriptions
    Log    Get the list of active subscriptions
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Get subscriptions with all_fields attribute selector
    Log    Get the list of active subscriptions, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?all_fields
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
Get subscriptions with exclude_default attribute selector
    Log    Get the list of active subscriptions, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
Get subscriptions with fields attribute selector
    Log    Get the list of active subscriptions, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?fields=${fields_sub}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}	
Get subscriptions with exclude_fields attribute selector
    Log    Get the list of active subscriptions, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?exclude_fields=${fields_sub}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}     
	
GET subscriptions with filter  
    Log    Get the list of active subscriptions using a filter
    Set Headers    {"Accept": "${ACCEPT}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?${sub_filter}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Get subscriptions - invalid filter
    Log    Get the list of active subscriptions using an invalid filter
    Set Headers    {"Accept": "${ACCEPT}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?${sub_filter_invalid} 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

POST Individual Subscription
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
PUT Individual Subscription
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
PATCH Individual Subscription
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

GET Individual subscription
    log    Trying to get information about an individual subscription
    Set Headers    {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}  
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Individual subscription
    log    Try to delete an individual subscription
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}    
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

POST Operation occurrence
    log    The POST method delivers a notification from the server to the client.
    ${json}=	Get File	schemas/NsLcmOperationOccurrenceNotification.schema.json
    ${BODY}=	evaluate	json.loads('''${json}''')	json
    Log  Creating mock request and response to handle NSLcmOperationOccurrenceNotification
    &{req}=  Create Mock Request Matcher	POST  ${callback_endpoint}  body_type="JSON_SCHEMA"    body=${BODY}
    &{rsp}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${req}  ${rsp}
    Sleep  ${sleep_interval}
    Log  Verifying results
    Verify Mock Expectation  ${req}
    Log  Cleaning the endpoint
    Clear Requests  ${callback_endpoint} 
 
POST Id creation
    log    The POST method delivers a notification from the server to the client.
    ${json}=	Get File	schemas/NsIdentifierCreationNotification.schema.json
    ${BODY}=	evaluate	json.loads('''${json}''')	json
    Log  Creating mock request and response to handle NsIdentifierCreationNotification
    &{req}=  Create Mock Request Matcher	POST  ${callback_endpoint}}  body_type="JSON_SCHEMA"    body=${BODY}
    &{rsp}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${req}  ${rsp}
    Sleep  ${sleep_interval}
    Log  Verifying results
    Verify Mock Expectation  ${req}
    Log  Cleaning the endpoint
    Clear Requests  ${callback_endpoint}

POST Id deletion
    log    The POST method delivers a notification from the server to the client.
    ${json}=	Get File	schemas/NsIdentifierDeletionNotification.schema.json
    ${BODY}=	evaluate	json.loads('''${json}''')	json
    Log  Creating mock request and response to handle NsIdentifierDeletionNotification
    &{req}=  Create Mock Request Matcher	POST  ${callback_endpoint}  body_type="JSON_SCHEMA"    body=${BODY}
    &{rsp}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${req}  ${rsp}
    Sleep  ${sleep_interval}
    Log  Verifying results
    Verify Mock Expectation  ${req}
    Log  Cleaning the endpoint
    Clear Requests  ${callback_endpoint}   

GET Notification endpoint
    log    The GET method allows the server to test the notification endpoint
    &{req}=  Create Mock Request Matcher	GET  ${callback_endpoint}    
    &{rsp}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${req}  ${rsp}
    Sleep  ${sleep_interval}
    Verify Mock Expectation  ${req}
    Clear Requests  ${callback_endpoint}
    
PUT notification
    Log  PUT Method not implemented
    &{req}=  Create Mock Request Matcher	PUT  ${callback_endpoint}
    &{rsp}=  Create Mock Response  status_code=405
    Create Mock Expectation  ${req}  ${rsp}
    Sleep  ${sleep_interval}
    Log  Verifying results
    Verify Mock Expectation  ${req}
    Log  Cleaning the endpoint
    Clear Requests  ${callback_endpoint}         
        
Check HTTP Response Header Contains Location
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}

PARSE the NS Descriptor File
    Run Keyword If  '${descriptorType}'=='SOL001'    Fetch Information from SOL001 NS descriptor file    ELSE    Fetch Information from SOL006 NS descriptor file

Fetch Information from SOL001 NS descriptor file
    Import Variables    ${CURDIR}/descriptors/SOL001/NSD/nsd_SOL001.yaml
    @{NsVirtualLink_labels}=    Create List
    @{NsCP_labels}=    Create List
    FOR    ${key}    IN    @{topology_template.node_templates.keys()} 
        ${key_type}=    Get Variable Value    ${topology_template.node_templates.${key}.type}
        ${NS_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}   ${tosca_type_NS}
        ${NSLink_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_NsVirtualLink}
        ${NsCP_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_NsCP}
        Run Keyword If    ${NS_check}    Get NS Attributes from SOL001    ${key}
        Run Keyword If    ${NSLink_check}    Append To List    ${Ns_VirtualLink_labels}    ${key}
        Run Keyword If    ${NsCP_check}    Append To List    ${NsCp_labels}    ${key}        
    END
    Set Global Variable    @{NS_VirtualLink_IDs}    @{NsVirtualLink_labels}
    Set Global Variable    @{NsCP_IDs}    @{NsCP_labels}

Get NS Attributes from SOL001
    [Arguments]    ${NS_label}
    Import Variables    ${CURDIR}/descriptors/SOL001/NSD/nsd_SOL001.yaml
    ${ns_descriptor_id}=    Get Variable Value    ${topology_template.node_templates.${NS_label}.properties.descriptorId}
    ${designer}=    Get Variable Value    ${topology_template.node_templates.${NS_label}.properties.designer}
    ${version}=    Get Variable Value    ${topology_template.node_templates.${NS_label}.properties.version}
    ${name}=    Get Variable Value    ${topology_template.node_templates.${NS_label}.properties.name}
    ${invariantId}=    Get Variable Value    ${topology_template.node_templates.${NS_label}.properties.invariantId}
    
    Set Global Variable    ${NS_DescriptorID}    ${ns_descriptor_id}
    Set Global Variable    ${Designer}    ${designer}
    Set Global Variable    ${NS_Version}    ${version}
    Set Global Variable    ${NS_Name}    ${name}
    Set Global Variable    ${NS_InvariantID}    ${invariantId}

Fetch Information from SOL006 NS descriptor file
    Import Variables    ${CURDIR}/descriptors/SOL006/NSD/nsd_SOL006.yaml
    ${nsd_id}=    Get Variable Value    ${nfv.nsd[0].id}
    ${VNFcount}=    Get Length    ${nfv.vnfd}
    ${SAPcount}=    Get Length    ${nfv.nsd[0].sapd}
    ${NSvirtualLinkCount}=    Get Length    ${nfv.nsd[0]['virtual-link-desc']}
    FOR    ${key}    IN    @{nfv.keys()}
        ${VNFD_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    vnfd
        ${NSD_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    nsd
        Run Keyword If    ${VNFD_check}    Fetch Information from SOL006 descriptor file
        Run Keyword If    ${NSD_check}    Get SAP IDs    ${SAPcount}
        Run Keyword If    ${NSD_check}    Get NS Virtual Link IDs    ${NSvirtualLinkCount}

    END
    Set Global Variable    ${NS_DescriptorID}    ${nsd_id}
    
Get SAP IDs
    [Arguments]    ${count}
    Import Variables    ${CURDIR}/descriptors/SOL006/NSD/nsd_SOL006.yaml
    @{SAPlabels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${SAPlabels}    ${nfv.nsd[0].sapd[${i}]['id']}
    END
    Set Global Variable    ${SAP_IDs}    ${SAPlabels}
    
Get NS Virtual Link IDs
    [Arguments]    ${count}
    Import Variables    ${CURDIR}/descriptors/SOL006/NSD/nsd_SOL006.yaml
    @{NsVirtualLink_labels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${NsVirtualLink_labels}    ${nfv.nsd[0]['virtual-link-desc'][${i}]['id']}
    END
    Set Global Variable    ${NS_VirtualLink_IDs}    ${NsVirtualLink_labels}
    
Check HTTP Response Body NsInstance content against NS Descriptor
    #${check_descriptors} flag, 1 to check descriptors
    Run Keyword If    ${check_descriptors} == 1    Check Individual NsInstance Content for NSD

Check Individual NsInstance Content for NSD 
    PARSE the NS Descriptor File
    Match the Response Attributes with NS Descriptors

Match the Response Attributes with NS Descriptors
    Should Be Equal As Strings    ${response['body']['nsdId']}    ${NSDescriptor_ID}
    List Should Contain Value    ${NS_VirtualLink_IDs}    ${response['body']['virtualLinkInfo'][0]['nsVirtualLinkDescId']}            
    Run Keyword If  '${descriptorType}'=='SOL006'    List Should Contain Value    ${SAP_IDs}    ${response['body']['sapInfo'][0]['sapdId']}

Check NsLcmOpOcc content against NS Descriptor
    PARSE the NS Descriptor File
    Match the NsLcmOpOcc Response Attributes with NS Descriptors

Match the NsLcmOpOcc Response Attributes with NS Descriptors
    Should Be Equal As Strings    ${response['body']['affectedNss'][0]['nsdId']}    ${NSDescriptor_ID}
    Run Keyword If  '${descriptorType}'=='SOL006'    List Should Contain Value    ${SAP_IDs}    ${response['body']['affectedSaps'][0]['sapdId']}
    
POST VNF Snapshots
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots   	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

GET multiple VNF Snapshots	
    Log    Query VNF The GET method queries information about multiple VNF snapshots.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 		

GET multiple VNF Snapshots with bad attribute	
    Log    Query VNF The GET method queries information about multiple VNF snapshots.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?attribute_not_exist=some_value
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

GET multiple VNF Snapshots with bad filter	
    Log    Query VNF The GET method queries information about multiple VNF snapshots.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?${NEG_FILTER_snapshot}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
	
GET multiple VNF Snapshots using filter	
    Log    Query VNF The GET method queries information about multiple VNF snapshots using filter.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?${POS_FILTER_snapshot}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
	
GET multiple VNF Snapshots with all_fields attribute selector
    Log    Query status information about multiple VNF snapshots, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?all_fields
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET multiple VNF Snapshots with exclude_default attribute selector
    Log    Query status information about multiple VNF snapshots using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET multiple VNF Snapshots with fields attribute selector
    Log    Query status information about multiple VNF snapshots, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?fields=${fields_snapshot}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}	    
    
GET multiple VNF Snapshots with exclude_default and fields attribute selector
    Log    Query status information about multiple VNF snapshots, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?fields=${fields_snapshot}&exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET multiple VNF Snapshots with exclude_fields attribute selector
    Log    Query status information about multiple VNF snapshots, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?exclude_fields=${fields_snapshot}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 	

GET VNF Snapshots without Paging support
    Run Keyword If    ${PAGING_SUPPORTED} == 0    GET multiple VNF Snapshots
    
GET VNF Snapshots with Paging support
    Run Keyword If    ${PAGING_SUPPORTED} == 1    GET multiple VNF Snapshots
    
Check HTTP Response Header Contains Link
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}

PUT VNF Snapshots
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots   	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH VNF Snapshots
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE VNF Snapshots
    Log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots 	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

POST individual VNF Snapshot
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId}    
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

GET individual VNF Snapshot
    log    Trying to get information about an individual VNF snapshot
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      

GET individual VNF Snapshot with invalid URI
    log    Trying to get information about an individual VNF snapshot
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${invalidVnfSnapshotInfoId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      
	
PUT individual VNF Snapshot
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH individual VNF Snapshot
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE individual VNF Snapshot
    log    Trying to DELETE an individual VNF Snapshot
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE individual VNF Snapshot - CONFLICT
    log    Trying to DELETE an individual VNF Snapshot that is already in use by another operation
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId_InUse} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
Check Postcondition VNF Snapshot Resource Is Deleted
    Get individual VNF Snapshot
    Integer    response status    404
    Log    VNF Snapshot Resource deleted
    
Check Postcondition VNF Snapshot Resource Existence
    Get individual VNF Snapshot
    Integer    response status    200
    Log    VNF Snapshot Resource is not deleted
    
Check Notification Http POST Request Body Json Schema Is  
    [Arguments]    ${element}
    ${schema}=	Get File	schemas/${element}.schema.json
    Configure Notification Forward    ${schema}    ${callback_endpoint}    ${callback_endpoint_fwd}

Check Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Configure Notification NS Creation Deletion Handler    ${callback_endpoint_fwd}    ${type}
    Wait Until Keyword Succeeds    ${total_polling_time}   ${polling_interval}   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}

Configure Notification NS Creation Deletion Handler
    [Arguments]    ${endpoint}    ${type}
    ${json}=    evaluate    {}
    set to dictionary   ${json}    notificationType    ${type}
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle status notification
    &{req}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON"    body=${BODY}
    Set Global Variable    ${notification_request}    ${req}    
    &{headers} =    Create Dictionary    Content-Type=application/json
    &{notification_response}=  Create Mock Response    headers=${headers}    status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}


