*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Resource          NFVMANOLogManagementKeywords.robot
Library           JSONLibrary
Library           OperatingSystem
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false


*** Test Cases ***
Request to compile the logged data into a file - Synchronous mode
    [Documentation]    Test ID: 8.3.4.4.1
    ...    Test title: Request to compile the logged data into a file - Synchronous mode
    ...    Test objective: The objective is to request to compile the logged data into a file in synchronous mode and perform a JSON schema validation on the returned log report data structure
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.6.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The NFV-MANO can decide immediately what to respond to a compile request
    ...    Post-Conditions: none
    Send Log data Request in Synchronous mode
    Check HTTP Response Status Code Is    201
    Check HTTP Response Header Contains Location
    Check HTTP Response Body Json Schema Is    LogReport

Request to compile the logged data into a file - Asynchronous mode
    [Documentation]    Test ID: 8.3.4.4.2
    ...    Test title: Request to compile the logged data into a file - Asynchronous mode
    ...    Test objective: The objective is to request to compile the logged data into a file in asynchronous mode
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.6.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: The NFV-MANO can not decide immediately what to respond to a compile request
    ...    Post-Conditions: none
    Send Log data Request in Asynchronous mode
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains Location
    Wait for compilation success notification 
    
Request to compile the logged data into a file - Already Processing
    [Documentation]    Test ID: 8.3.4.4.3
    ...    Test title: Request to compile the logged data into a file - Already Processing
    ...    Test objective: The objective is to request to compile the logged data into a file when a log data compilation and report creation is already ongoing, or a log report has just been created, for the specified logging job at the time of processing the request
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.6.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Log data Request
    Check HTTP Response Status Code Is    303
    Check HTTP Response Header Contains Location
    
Request to compile the logged data into a file with unprocessable entity
        [Documentation]    Test ID: 8.3.4.4.4
    ...    Test title: Request to compile the logged data into a file with unprocessable entity
    ...    Test objective:  The objective is to test that the rrequest to compile the logged data into a file fails when error in request body. 
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.6.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Log data Request
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is    ProblemDetails 
    
GET Compiled Log Data - Method not implemented
    [Documentation]    Test ID: 8.3.4.4.5
    ...    Test title: GET Compiled Log Data - Method not implemented
    ...    Test objective: The objective is to test that GET method is not allowed to retrieve compiled log data.
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.6.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Get Compiled Log Data
    Check HTTP Response Status Code Is    405
    
PUT Compiled Log Data - Method not implemented
    [Documentation]    Test ID: 8.3.4.4.6
    ...    Test title: PUT Compiled Log Data - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update compiled log data.
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.6.3.3 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Compiled Log Data
    Check HTTP Response Status Code Is    405
    
PATCH Compiled Log Data - Method not implemented
    [Documentation]    Test ID: 8.3.4.4.7
    ...    Test title: PATCH Compiled Log Data - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update compiled log data.
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.6.3.4 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Compiled Log Data
    Check HTTP Response Status Code Is    405
    
DELETE Compiled Log Data - Method not implemented
    [Documentation]    Test ID: 8.3.4.4.8
    ...    Test title: DELETE Compiled Log Data - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to update compiled log data.
    ...    Pre-conditions: none
    ...    Reference: clause 8.5.6.3.5 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send DELETE Compiled Log Data
    Check HTTP Response Status Code Is    405
    