*** Settings ***
Library    String
Resource   environment/variables.txt
Library    REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library    MockServerLibrary 
Library    OperatingSystem
Library    BuiltIn
Library    JSONLibrary
Library    Collections
Library    JSONSchemaLibrary    schemas/
Library    Process

*** Keywords ***
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    ${status}=    Convert To Integer    ${expected_status}    
    Should Be Equal    ${response['status']}    ${status} 
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK

POST Create a new logging job	
     Log    Create a logging job
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${body}=    Get File    jsons/createLoggingJobRequest.json
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
Check Post-Condition Logging job is created
    GET Logging Jobs
    Check HTTP Response Status Code Is    200
	
GET Logging Jobs
    Log    Query to GET information about logging jobs.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
GET Logging Jobs with malformed authorization token
    Pass Execution If    ${AUTH_USAGE} == 0    Skipping test as NFVO is not supporting authentication
    Log    The GET method queries using invalid token
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Authorization": "${BAD_AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET Logging Jobs without authorization token
    Pass Execution If    ${AUTH_USAGE} == 0    Skipping test as it is not supporting authentication
    Log    The GET method queries omitting token
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET Logging Jobs with expired or revoked authorization token
    Pass Execution If    ${AUTH_USAGE} == 0    Skipping test as it is not supporting authentication
    Log    The GET method queries  using invalid token
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Authorization": "${NEG_AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET Logging Job with invalid filter
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs?attribute_not_exist=some_value
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}	
	
GET Logging Job with invalid selector
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs?fields=wrong_field
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}	
	
GET Logging Job with filter
	Log    Query  information about logging jobs with filters.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs?${alarm_filter}=${filter_value} 
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
	
GET Logging jobs with all_fields attribute selector
	Log    Queries information about logging jobs, using all_fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET Logging Jobs with exclude_default attribute selector
    Log    Queries information about logging jobs, using exclude_default
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET Logging Jobs with fields attribute selector
    Log    Queries information about Logging Jobs, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET Logging Jobs with fields and exclude_default attribute selector
    Log    Queries information about Logging Jobs, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs?exclude_default&fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET Logging Jobs with exclude_fields attribute selector
    Log    Query NFV-MANO The GET method queries information about multiple alarms, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs?exclude_fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Check HTTP Response Header Contains Link
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}

PUT Logging Jobs
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
PATCH Logging Jobs
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}
DELETE Logging Jobs
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}		
	
Send Post request for individual Logging Job    
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET individual Logging Job
    Log    Trying to get a Logging Job 
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Check HTTP Response Body Logging Job Identifier matches the requested Logging Job
    Log    Going to validate Logging Job info retrieved
    Should Be Equal    ${response['body']['id']}    ${logJobId} 
    Log    Logging Job identifier as expected


GET individual Logging Job with invalid resource identifier  
    Log    Trying to perform a negative get, using erroneous logging Job identifier
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Put request for individual Logging Job    
    Log    Trying to perform a PUT (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch request for individual Logging Job    
    Log    Trying to perform a PATCH (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}


Send Delete request for individual Logging Job
    Log    Trying to delete an existing logging Job
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Check Postcondition Logging Job is Deleted
    Log    Check Postcondition
    GET individual Logging Job
    Check HTTP Response Status Code Is    404

Send Delete request for individual Logging Job with invalid resource identifier
    Log    Trying to perform a negative delete, using erroneous Logging Job identifier
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${erroneousLogJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Post request for Individual Log Report
    Log    Trying to create new log report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/log_reports/${newReportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Get Individual Log Report
    Log    Trying to get log report
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/log_reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Get Individual Log Report with invalid resource endpoint
    Log    Trying to get a log report with invalid resource endpoint
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/log_reports/${erroneousReportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Put request for Individual Log Report
    Log    Trying to update log report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/log_reports/${reportId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/log_reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch request for Individual Log Report
    Log    Trying to update log report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/log_reports/${reportId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/log_reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for Individual Log Report
    Log    Trying to delete log report   
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/log_reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Log data Request in Synchronous mode
    Log    Request to compile the logged data into a file Synchronous mode
    Pass Execution If    ${SYNC_MODE} == 0    The compile process is asynchronous mode. Skipping the test
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    ${template}=    Get File    jsons/compileLogRequest.json
    ${body}=        Format String   ${template}     objectInstanceId=${objectInstanceId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/compile_log    ${body}
    ${body}=    Output    response
    Set Suite Variable    &{response}    ${body}

Check HTTP Response Header Contains Location
    ${vnfLcmOpOccId}=    Get Value From Json    ${response['headers']}    $..Location
    Should Not Be Empty    ${vnfLcmOpOccId}

Send Log data Request in Asynchronous mode
    Log    Request to compile the logged data into a file Asynchronous mode
    Pass Execution If    ${SYNC_MODE} == 1    The compile process is synchronous mode. Skipping the test
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    ${template}=    Get File    jsons/compileLogRequest.json
    ${body}=        Format String   ${template}     objectInstanceId=${objectInstanceId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/compile_log    ${body}
    ${body}=    Output    response
    Set Suite Variable    &{response}    ${body}
    
 Wait for compilation success notification 
    Wait Until Keyword Succeeds    ${retry}   ${polling}    Get success notification
    
Get Success notification
    log    Trying to read an compiled file
    Set Headers    {"Accept":"${ACCEPT}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${response['headers']['Location']}
    Log    Validate Status code
    Integer    response status    200
    ${result}    Output    response body
    Validate Json   LogReport.schema.json    ${result}
    Log    Validation OK
    
Send Log data Request
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template}=    Get File    jsons/createLoggingJobRequest.json
    ${body}=        Format String   ${template}     objectInstanceId=${objectInstanceId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/compile_log    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    @{response}    ${outputResponse}

Send Get Compiled Log Data
    Log    Trying to delete log report   
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/compile_log
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Put Compiled Log Data
    Log    Trying to update log report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/compile_log
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/compile_log
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch Compiled Log Data
    Log    Trying to update log report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/compile_log
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/compile_log
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete Compiled Log Data
    Log    Trying to delete log report   
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/log_jobs/${logJobId}/compile_log
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Create Sessions
    Pass Execution If    ${NFVMANO_CHECKS_NOTIF_ENDPOINT} == 0   MockServer not necessary to run    
    Start Process  java  -jar  ${MOCK_SERVER_JAR}    -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}:${callback_port}
    
Check Notification Endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}    
    &{notification_response}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Wait Until Keyword Succeeds    ${total_polling_time}   ${polling_interval}   Verify Mock Expectation    ${notification_request}
    Clear Requests  ${callback_endpoint}

Get all Subscriptions
    [Documentation]    The api consumer can use this method to query the list of active subscriptions to log management notifications
    Set headers    {"Accept": "application/json"}
    Set headers    {"Content-Type": "application/json"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
 Get Subscriptions with attribute-based filters
    [Documentation]    The api consumer can use this method to query the list of active subscriptions to log management notifications
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?${filter_ok}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get Subscriptions with invalid attribute-based filters
    [Documentation]    The api consumer can use this method to query the list of active subscriptions to log management notifications
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?${filter_ko}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Post Request for Subscription
    Set headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": ${AUTHORIZATION}"}
    ${template}=    Get File    jsons/subscriptions.json
    ${body}=        Format String   ${template}     callback_uri=${callback_uri}    callback_endpoint=${callback_endpoint}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Check HTTP Response Body LogmSubscription Attributes Values Match the Issued Subscription
    Log    Check Response matches subscription
    ${template}=    Get File    jsons/subscriptions.json
    ${body}=        Format String   ${template}     callback_uri=${callback_uri}    callback_endpoint=${callback_endpoint}
    ${subscription}=    evaluate    json.loads('''${body}''')    json
    Should Be Equal As Strings    ${response['body']['callbackUri']}    ${subscription['callbackUri']}

Check Postcondition Subscription Is Set
    Log    Check Postcondition subscription exist
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${response['body']['id']}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    Check HTTP Response Status Code Is    200
    
Send Post Request for Duplicated Subscription
    Set headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    ${template}=    Get File    jsons/subscriptions.json
    ${body}=        Format String   ${template}     callback_uri=${callback_uri}    callback_endpoint=${callback_endpoint}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}  
    
Check HTTP Response Body Is Empty
    Should Be Empty    ${response['body']}    
    Log    No json schema is provided. Validation OK  
    
Check Postcondition Subscription Resource Returned in Location Header Is Available
    Log    Going to check postcondition
    GET    ${response['headers']['Location']}
    Integer    response status    200
    Log    Received a 200 OK as expected
    ${contentType}=    Output    response headers Content-Type
    Should Contain    ${contentType}    application/json
    ${result}=    Output    response body
    Validate Json    LogmSubscription.schema.json    ${result}
    Log    Validated LogmSubscription schema
    ${body}=    Get File    jsons/subscriptions.json
    ${subscription}=    evaluate    json.loads('''${body}''')    json
    Should Be Equal    ${result['callbackUri']}    ${subscription['callbackUri']}
    Log    Validated Issued subscription is same as original
    
Send Put Request for Subscriptions
    [Documentation]    This method is not supported. When this method is requested on this resource, the NFV-MANO shall return a "405 Method
    ...    Not Allowed" response as defined in clause 4.3.5.4.
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Patch Request for Subscriptions
    [Documentation]    This method is not supported. When this method is requested on this resource, the NFV-MANO shall return a "405 Method
    ...    Not Allowed" response as defined in clause 4.3.5.4.
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete Request for Subscriptions
    [Documentation]    This method is not supported. When this method is requested on this resource, the NFV-MANO shall return a "405 Method
    ...    Not Allowed" response as defined in clause 4.3.5.4.
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get Individual Subscription
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Check HTTP Response Body Subscription Identifier matches the requested Subscription
    Log    Trying to check response ID
    Should Be Equal As Strings    ${response['body']['id']}    ${subscriptionId} 
    Log    Subscription identifier as expected
    
GET individual Subscription with invalid resource identifier
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${erroneousSubscriptionId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for individual Subscription
    Set headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Check Postcondition Subscription is Deleted
    Log    Check Postcondition Subscription is deleted
    GET individual Subscription
    Check HTTP Response Status Code Is    404 

Send Delete request for individual Subscription with invalid resource identifier
    Log    Trying to delete a subscription in the VNFM with invalid id
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${erroneousSubscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}
    
Send Post request for individual Subscription
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${newSubscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Put request for individual Subscription
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}
    
Send Patch request for individual Threshold
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization": "${AUTHORIZATION}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}